/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiSlider
extends GuiControl
implements IGuiParent {
    public double maxValue;
    public double minValue;
    public double value;
    protected boolean grabbedSlider;
    public int sliderWidth = 4;
    protected GuiTextfield textfield;

    public GuiSlider(String name, double value, double min, double max) {
        super(name);
        this.minValue = min;
        this.maxValue = max;
        this.setValue(value);
    }

    public String getTextByValue() {
        return "" + (float)Math.round(this.value * 100.0) / 100.0f;
    }

    public String getTextfieldValue() {
        return this.getTextByValue();
    }

    public double getPercentage() {
        return (this.value - this.minValue) / (this.maxValue - this.minValue);
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (button == 0) {
            if (this.textfield != null) {
                return this.textfield.mouseClicked(rect, x, y, button);
            }
            GuiSlider.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
            this.grabbedSlider = true;
            this.mouseMoved(rect, x, y);
            return true;
        }
        if (button == 1) {
            this.grabbedSlider = false;
            this.textfield = this.createTextfield(rect);
            this.textfield.focus();
            this.textfield.setText(this.getTextfieldValue());
            this.textfield.setCursorPositionEnd();
            this.textfield.setParent(this);
            int width = (int)rect.getWidth();
            this.textfield.flowX(width, width);
            return true;
        }
        return false;
    }

    protected GuiTextfield createTextfield(Rect rect) {
        return new GuiTextfield(this.getNestedName() + ".text").setFloatOnly().setDim((int)rect.getWidth() - this.getContentOffset() * 2, (int)rect.getHeight() - this.getContentOffset() * 2);
    }

    public void closeTextField() {
        double value = this.value;
        try {
            this.setValue(this.textfield.parseFloat());
            GuiSlider.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
        }
        catch (NumberFormatException e) {
            this.setValue(value);
        }
        this.textfield = null;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.textfield != null) {
            if (keyCode == 257) {
                this.closeTextField();
                return true;
            }
            return this.textfield.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        if (this.textfield != null) {
            return this.textfield.charTyped(codePoint, modifiers);
        }
        return super.charTyped(codePoint, modifiers);
    }

    public void setValue(double value) {
        this.value = Math.max(this.minValue, value);
        this.value = Math.min(this.maxValue, this.value);
        if (this.getParent() != null) {
            this.raiseEvent(new GuiControlChangedEvent(this));
        }
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        if (this.grabbedSlider) {
            int width = (int)rect.getWidth() - this.getContentOffset() * 2 - this.sliderWidth;
            if (x < (double)this.getContentOffset()) {
                this.value = this.minValue;
            } else if (x > (double)(this.getContentOffset() + width + this.sliderWidth / 2)) {
                this.value = this.maxValue;
            } else {
                int mouseOffsetX = (int)(x - (double)this.getContentOffset() - (double)(this.sliderWidth / 2));
                this.value = (float)(this.minValue + (double)((float)((this.maxValue - this.minValue) * (double)((float)mouseOffsetX / (float)width))));
            }
            this.setValue(this.value);
        }
    }

    @Override
    public void looseFocus() {
        if (this.textfield != null) {
            this.closeTextField();
        }
        super.looseFocus();
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        if (this.grabbedSlider) {
            this.grabbedSlider = false;
        }
    }

    @Override
    public boolean isContainer() {
        return this.getParent().isContainer();
    }

    @Override
    public void closeTopLayer() {
        this.getParent().closeTopLayer();
    }

    @Override
    public Rect toLayerRect(GuiControl control, Rect rect) {
        return this.getParent().toLayerRect(this, rect);
    }

    @Override
    public Rect toScreenRect(GuiControl control, Rect rect) {
        return this.getParent().toScreenRect(this, rect);
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED_NO_PADDING;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        double percent = this.getPercentage();
        int posX = (int)((double)(control.getContentWidth() - this.sliderWidth) * percent);
        PoseStack pose = graphics.pose();
        GuiStyle style = this.getStyle();
        style.get(ControlFormatting.ControlStyleFace.CLICKABLE, false).render(pose, posX, 0.0, this.sliderWidth, control.getContentHeight());
        if (this.textfield != null) {
            this.textfield.render(graphics, control, rect, rect, 1.0, mouseX, mouseY);
        } else {
            GuiRenderHelper.drawStringCentered(pose, this.getTextByValue(), control.getContentWidth(), control.getContentHeight(), -1, true);
        }
    }

    @Override
    public void flowX(int width, int preferred) {
        if (this.textfield != null) {
            this.textfield.flowX(width, preferred);
        }
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        if (this.textfield != null) {
            this.textfield.flowY(width, height, preferred);
        }
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 40;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 10;
    }

    @Override
    public void closeLayer(GuiLayer layer) {
        this.getParent().closeLayer(layer);
    }
}

