/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.filter;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.common.util.CompoundSerializer;
import team.creative.creativecore.common.util.filter.Filter;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;
import team.creative.creativecore.common.util.registry.exception.RegistryException;

public class FilterSerializer {
    private final NamedTypeRegistry<Filter> REGISTRY = new NamedTypeRegistry().addConstructorPattern(CompoundTag.class);

    public <V extends Filter & CompoundSerializer> FilterSerializer register(String id, Class<V> clazz) {
        this.REGISTRY.register(id, clazz);
        return this;
    }

    public CompoundTag write(Filter filter) throws RegistryException {
        if (filter instanceof Filter.FilterAnd) {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (Filter child : ((Filter.FilterAnd)filter).filters) {
                list.add((Object)this.write(child));
            }
            tag.put("c", (Tag)list);
            tag.putString("t", "&");
            return tag;
        }
        if (filter instanceof Filter.FilterOr) {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (Filter child : ((Filter.FilterOr)filter).filters) {
                list.add((Object)this.write(child));
            }
            tag.put("c", (Tag)list);
            tag.putString("t", "+");
            return tag;
        }
        if (filter instanceof Filter.FilterNot) {
            CompoundTag tag = new CompoundTag();
            tag.put("c", (Tag)this.write(((Filter.FilterNot)filter).filter));
            tag.putString("t", "!");
            return tag;
        }
        if (filter instanceof CompoundSerializer) {
            CompoundTag tag = ((CompoundSerializer)((Object)filter)).write();
            tag.putString("t", this.REGISTRY.getId(filter));
            return tag;
        }
        throw new RegistryException("Type not registered " + filter.getClass());
    }

    public Filter read(CompoundTag tag) throws RegistryException {
        String type = tag.getString("t");
        if (type.equals("&")) {
            ListTag list = tag.getList(type, 10);
            Filter[] filters = new Filter[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                filters[i] = this.read(list.getCompound(i));
            }
            return new Filter.FilterAnd(filters);
        }
        if (type.equals("+")) {
            ListTag list = tag.getList(type, 10);
            Filter[] filters = new Filter[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                filters[i] = this.read(list.getCompound(i));
            }
            return new Filter.FilterOr(filters);
        }
        if (type.equals("!")) {
            return new Filter.FilterNot(this.read(tag.getCompound("c")));
        }
        return this.REGISTRY.create(type, tag);
    }
}

