/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;

public class CreativeIngredientBlock
extends CreativeIngredient {
    public Block block;

    public CreativeIngredientBlock(Block block) {
        this.block = block;
    }

    public CreativeIngredientBlock() {
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        this.block = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(nbt.getString("block")));
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        nbt.putString("block", BuiltInRegistries.BLOCK.getKey((Object)this.block).toString());
    }

    @Override
    public boolean is(CreativeIngredient info) {
        if (info instanceof CreativeIngredientBlock) {
            return ((CreativeIngredientBlock)info).block == this.block;
        }
        if (info instanceof CreativeIngredientItemStack) {
            return this.block == Block.byItem((Item)((CreativeIngredientItemStack)info).stack.getItem());
        }
        return false;
    }

    @Override
    public boolean is(ItemStack stack) {
        return Block.byItem((Item)stack.getItem()) == this.block;
    }

    @Override
    public boolean equals(CreativeIngredient object) {
        return object instanceof CreativeIngredientBlock && ((CreativeIngredientBlock)object).block == this.block;
    }

    @Override
    public ItemStack getExample() {
        return new ItemStack((ItemLike)this.block);
    }

    @Override
    public CreativeIngredient copy() {
        return new CreativeIngredientBlock(this.block);
    }

    @Override
    public Component description() {
        return this.block.getName();
    }

    @Override
    public Component descriptionDetail() {
        return Component.translatable((String)"minecraft.block").append(": " + ChatFormatting.YELLOW + BuiltInRegistries.BLOCK.getKey((Object)this.block).toString());
    }
}

