/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextListBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiCreativeIngredientHandler {
    public static final NamedHandlerRegistry<GuiCreativeIngredientHandler> REGISTRY = new NamedHandlerRegistry<Object>(null);

    public static GuiCreativeIngredientHandler find(CreativeIngredient info) {
        if (info != null) {
            for (GuiCreativeIngredientHandler handler : REGISTRY.values()) {
                if (!handler.canHandle(info)) continue;
                return handler;
            }
        }
        return REGISTRY.getDefault();
    }

    public abstract boolean canHandle(CreativeIngredient var1);

    public abstract void createControls(GuiParent var1, CreativeIngredient var2);

    public abstract CreativeIngredient parseControls(GuiParent var1);

    public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
    }

    static {
        REGISTRY.registerDefault("Default", new GuiCreativeIngredientHandler(){

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                GuiStackSelector selector = (GuiStackSelector)new GuiStackSelector("inv", null, new GuiStackSelector.CreativeCollector(new GuiStackSelector.SearchSelector())).setExpandableX();
                gui.add(selector);
                gui.add(new GuiLabel("guilabel1"));
                gui.add(new GuiLabel("guilabel2"));
                GuiStateButton damage = new GuiStateButton("damage", 0, new TextListBuilder().add("Damage: Off", "Damage: On"));
                gui.add(damage);
                GuiStateButton nbt = new GuiStateButton("nbt", 0, new TextListBuilder().add("NBT: Off", "NBT: On"));
                gui.add(nbt);
                if (info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack) {
                    selector.setSelectedForce(info.getExample().copy());
                    if (info instanceof CreativeIngredientItemStack) {
                        damage.nextState();
                        if (((CreativeIngredientItemStack)info).needNBT) {
                            nbt.nextState();
                        }
                    }
                }
                this.onChanged(gui, new GuiControlChangedEvent(selector));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack;
            }

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                ItemStack stack = ((GuiStackSelector)gui.get("inv")).getSelected();
                if (stack != null) {
                    boolean nbt;
                    boolean damage = ((GuiStateButton)gui.get("damage")).getState() == 1;
                    boolean bl = nbt = ((GuiStateButton)gui.get("nbt")).getState() == 1;
                    if (damage) {
                        return new CreativeIngredientItemStack(stack.copy(), nbt);
                    }
                    if (!(Block.byItem((Item)stack.getItem()) instanceof AirBlock)) {
                        return new CreativeIngredientBlock(Block.byItem((Item)stack.getItem()));
                    }
                    return new CreativeIngredientItem(stack.getItem());
                }
                return null;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                GuiStackSelector selector;
                if (event.control.is("inv") && (selector = (GuiStackSelector)event.control) != null) {
                    ItemStack stack = selector.getSelected();
                    if (!stack.isEmpty()) {
                        ((GuiLabel)gui.get("guilabel1")).setTitle((Component)Component.literal((String)("damage: " + stack.getDamageValue())));
                        ((GuiLabel)gui.get("guilabel2")).setTitle((Component)Component.literal((String)("nbt: " + stack.getTag())));
                    } else {
                        ((GuiLabel)gui.get("guilabel1")).setTitle((Component)Component.literal((String)""));
                        ((GuiLabel)gui.get("guilabel2")).setTitle((Component)Component.literal((String)""));
                    }
                }
            }
        });
        REGISTRY.register("Blocktag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                TagKey tag = (TagKey)box.getSelected();
                if (tag != null) {
                    return new CreativeIngredientBlockTag((TagKey<Block>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBoxMapped<TagKey> box = new GuiComboBoxMapped<TagKey>("tag", new TextMapBuilder<TagKey>().addComponents(BuiltInRegistries.BLOCK.getTagNames().toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Optional tag = BuiltInRegistries.BLOCK.getTag(x);
                    if (tag.isPresent() && ((HolderSet.Named)tag.get()).size() > 0) {
                        builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).get(0).value()));
                    }
                    return builder.text(x.location().toString()).build();
                }));
                gui.add(box);
                gui.add(new GuiTextfield("search"));
                if (info instanceof CreativeIngredientBlockTag) {
                    box.select(((CreativeIngredientBlockTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlockTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                    box.setLines(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(BuiltInRegistries.BLOCK.getTagNames().toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Optional tag = BuiltInRegistries.BLOCK.getTag(x);
                        if (tag.isPresent() && ((HolderSet.Named)tag.get()).size() > 0) {
                            builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).get(0).value()));
                        }
                        return builder.text(x.location().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Itemtag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                TagKey tag = (TagKey)box.getSelected();
                if (tag != null) {
                    return new CreativeIngredientItemTag((TagKey<Item>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBoxMapped<TagKey> box = new GuiComboBoxMapped<TagKey>("tag", new TextMapBuilder<TagKey>().addComponents(BuiltInRegistries.ITEM.getTagNames().toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Optional tag = BuiltInRegistries.ITEM.getTag(x);
                    if (tag.isPresent() && ((HolderSet.Named)tag.get()).size() > 0) {
                        builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).get(0).value()));
                    }
                    return builder.text(x.location().toString()).build();
                }));
                gui.add(box);
                gui.add(new GuiTextfield("search"));
                if (info instanceof CreativeIngredientItemTag) {
                    box.select(((CreativeIngredientItemTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientItemTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                    box.setLines(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(BuiltInRegistries.ITEM.getTagNames().toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Optional tag = BuiltInRegistries.ITEM.getTag(x);
                        if (tag.isPresent() && ((HolderSet.Named)tag.get()).size() > 0) {
                            builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).get(0).value()));
                        }
                        return builder.text(x.location().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Fuel", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                return new CreativeIngredientFuel();
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.add(new GuiLabel("info").setTitle((Component)Component.literal((String)"Nothing to select")));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientFuel;
            }
        });
    }
}

