/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.mc;

import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForgeMod;

public class PlayerUtils {
    public static CompoundTag getPersistentData(Player player) {
        return player.getPersistentData();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static GameType getGameTypeClient(Player player) {
        return Minecraft.getInstance().gameMode.getPlayerMode();
    }

    public static boolean isAdventure(Player player) {
        return PlayerUtils.getGameType(player) == GameType.ADVENTURE;
    }

    public static GameType getGameType(Player player) {
        if (player instanceof ServerPlayer) {
            return ((ServerPlayer)player).gameMode.getGameModeForPlayer();
        }
        return PlayerUtils.getGameTypeClient(player);
    }

    public static double getReach(Player player) {
        double attrib = player.getAttribute((Attribute)NeoForgeMod.BLOCK_REACH.value()).getValue();
        return player.isCreative() ? attrib : attrib - 0.5;
    }
}

