/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.mc;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.Resource;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.util.mc.PlatformResourceUtils;
import team.creative.creativecore.mixin.FilePackResourcesAccessor;
import team.creative.creativecore.mixin.PathPackResourcesAccessor;
import team.creative.creativecore.mixin.SharedZipFileAccessAccessor;
import team.creative.creativecore.mixin.VanillaPackResourcesAccessor;

public class ResourceUtils {
    public static long length(PackType type, Resource resource, ResourceLocation location) {
        return ResourceUtils.length(type, resource.source(), location);
    }

    public static long length(PackType type, PackResources source, ResourceLocation location) {
        if (source instanceof FilePackResourcesAccessor) {
            FilePackResourcesAccessor zip = (FilePackResourcesAccessor)source;
            ZipEntry entry = ((SharedZipFileAccessAccessor)zip.getZipFileAccess()).callGetOrCreateZipFile().getEntry(FilePackResourcesAccessor.callGetPathFromLocation(type, location));
            if (entry != null) {
                return entry.getSize();
            }
            return 0L;
        }
        Path path = (Path)FileUtil.decomposePath((String)location.getPath()).get().map(x -> {
            if (source instanceof VanillaPackResourcesAccessor) {
                VanillaPackResourcesAccessor vanilla = (VanillaPackResourcesAccessor)source;
                return ResourceUtils.resolve(vanilla.getPathsForType().get(type), location, x);
            }
            if (source instanceof PathPackResourcesAccessor) {
                PathPackResourcesAccessor pack = (PathPackResourcesAccessor)source;
                return FileUtil.resolvePath((Path)pack.getRoot().resolve(type.getDirectory()).resolve(location.getNamespace()), (List)x);
            }
            return PlatformResourceUtils.resolvePath(type, source, location, x);
        }, x -> {
            CreativeCore.LOGGER.error("Invalid path {}: {}", (Object)location, (Object)x.message());
            return null;
        });
        if (path != null) {
            return path.toFile().length();
        }
        return 0L;
    }

    private static Path resolve(List<Path> rootPaths, ResourceLocation location, List<String> parts) {
        for (Path path : rootPaths) {
            Path path1 = FileUtil.resolvePath((Path)path.resolve(location.getNamespace()), parts);
            if (!Files.exists(path1, new LinkOption[0]) || !PathPackResources.validatePath((Path)path1)) continue;
            return path1;
        }
        return null;
    }
}

