/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.parser.DoubleValueParser;
import team.creative.creativecore.common.gui.parser.IntValueParser;
import team.creative.creativecore.common.gui.parser.LongValueParser;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.math.TimeMath;

public class ValueParsers {
    public static final DoubleValueParser BLOCKS = (v, max) -> Component.m_237110_((String)"minecraft.blocks.counting", (Object[])new Object[]{Float.valueOf(ValueParsers.round(v))}).getString();
    public static final DoubleValueParser NONE = (v, max) -> String.valueOf(ValueParsers.round(v));
    public static final DoubleValueParser PERCENT = (v, max) -> (int)(ValueParsers.safeDivide(v, max) * 100.0) + "%";
    public static final DoubleValueParser ANGLE = (v, max) -> ValueParsers.round(v) + "\u00b0";
    public static final IntValueParser PIXELS = (v, max) -> v + "px";
    public static final LongValueParser TIME = (v, max) -> TimeMath.timestamp(v > max ? ValueParsers.safePercent(v, max) : v);
    public static final LongValueParser TIME_DURATION = (v, max) -> TIME.parse(v, max) + "/" + TimeMath.timestamp(max);
    public static final LongValueParser TIME_TICK = (v, max) -> TimeMath.timestamp(Maths.tickToMs((int)(v > max ? ValueParsers.safePercent(v, max) : v)));
    public static final LongValueParser TIME_DURATION_TICK = (v, max) -> TIME_TICK.parse(v, max) + "/" + TimeMath.timestamp(Maths.tickToMs((int)max));

    private static double safeDivide(double v1, double v2) {
        if (v1 == 0.0 || v2 == 0.0) {
            return 0.0;
        }
        return v1 / v2;
    }

    private static long safePercent(long v1, long v2) {
        if (v1 == 0L || v2 == 0L) {
            return 0L;
        }
        return v1 % v2;
    }

    private static float round(double value) {
        return value != 0.0 ? (float)Math.round(value * 100.0) / 100.0f : 0.0f;
    }
}

