/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.ValueParsers;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.parser.LongValueParser;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiSeekBar
extends GuiControl {
    private final LongSupplier posSupplier;
    private final LongSupplier maxSupplier;
    public LongConsumer posConsumer;
    public LongConsumer lastPosConsumer;
    private long pos;
    private long max;
    public final LongValueParser parser;
    public boolean grabbedSlider;

    public GuiSeekBar(String name, LongSupplier posSupplier, LongSupplier maxSupplier) {
        this(name, posSupplier, maxSupplier, ValueParsers.TIME_DURATION);
    }

    public GuiSeekBar(String name, LongSupplier posSupplier, LongSupplier maxSupplier, LongValueParser parser) {
        super(name);
        this.posSupplier = posSupplier;
        this.maxSupplier = maxSupplier;
        this.parser = parser;
        this.tick();
    }

    public GuiSeekBar setPosConsumer(LongConsumer consumer) {
        this.posConsumer = consumer;
        return this;
    }

    public GuiSeekBar setLastPosConsumer(LongConsumer consumer) {
        this.lastPosConsumer = consumer;
        return this;
    }

    public void setPosition(long value) {
        this.posConsumer.accept(value);
        this.pos = value;
        if (this.getParent() != null) {
            this.raiseEvent(new GuiControlChangedEvent(this));
        }
    }

    @Override
    public GuiSeekBar setTooltip(List<Component> tooltip) {
        return (GuiSeekBar)super.setTooltip(tooltip);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        double percent = (double)this.pos / (double)this.max;
        PoseStack pose = graphics.m_280168_();
        this.renderProgress(pose, control, rect, percent);
        GuiRenderHelper.drawStringCentered(pose, this.parser.parse(this.pos, this.max), (float)rect.getWidth(), (float)rect.getHeight(), this.getStyle().fontColor.toInt(), true);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderProgress(PoseStack pose, GuiChildControl control, Rect rect, double percent) {
        this.getStyle().clickable.render(pose, 0.0, 0.0, rect.getWidth() * percent, rect.getHeight());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (button == 0) {
            GuiSeekBar.playSound((Holder.Reference<SoundEvent>)SoundEvents.f_12490_);
            this.grabbedSlider = true;
            this.mouseMoved(rect, x, y);
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void mouseMoved(Rect rect, double x, double y) {
        if (this.grabbedSlider) {
            long value;
            int width = (int)rect.getWidth() - this.getContentOffset() * 2;
            if (x < (double)this.getContentOffset()) {
                value = 0L;
            } else if (x > (double)(this.getContentOffset() + width)) {
                value = this.maxSupplier.getAsLong();
            } else {
                int mouseOffsetX = (int)(x - (double)this.getContentOffset());
                value = (long)((float)this.maxSupplier.getAsLong() * ((float)mouseOffsetX / (float)width));
            }
            this.setPosition(value);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void mouseReleased(Rect rect, double x, double y, int button) {
        if (this.grabbedSlider) {
            this.lastPosConsumer.accept(this.pos);
            this.grabbedSlider = false;
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
        if (!this.grabbedSlider) {
            this.pos = this.posSupplier.getAsLong();
            this.max = this.maxSupplier.getAsLong();
        }
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.PROGRESSBAR;
    }

    @Override
    public void flowX(int width, int preferred) {
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 40;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 10;
    }
}

