/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.creativecore.common.util.text.TextBuilder;

public abstract class GuiControl {
    private IGuiParent parent;
    public final String name;
    public boolean enabled = true;
    public GuiSizeRule preferred;
    public boolean expandableX = false;
    public boolean expandableY = false;
    public boolean visible = true;
    private List<Component> customTooltip;

    public GuiControl(String name) {
        this.name = name;
    }

    public boolean isClient() {
        if (this.parent != null) {
            return this.parent.isClient();
        }
        return CreativeCore.loader().getEffectiveSide().isClient();
    }

    public GuiControl setTooltip(List<Component> tooltip) {
        this.customTooltip = tooltip != null && tooltip.isEmpty() ? null : tooltip;
        return this;
    }

    public GuiControl setTooltip(String translate) {
        this.setTooltip(new TextBuilder().translate(translate).build());
        return this;
    }

    public GuiControl setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GuiControl setFixed() {
        this.expandableX = false;
        this.expandableY = false;
        return this;
    }

    public GuiControl setFixedX() {
        this.expandableX = false;
        return this;
    }

    public GuiControl setFixedY() {
        this.expandableY = false;
        return this;
    }

    public GuiControl setExpandable() {
        this.expandableX = true;
        this.expandableY = true;
        return this;
    }

    public GuiControl setUnexpandable() {
        this.expandableX = false;
        this.expandableY = false;
        return this;
    }

    public GuiControl setExpandableX() {
        this.expandableX = true;
        return this;
    }

    public GuiControl setUnexpandableX() {
        this.expandableX = false;
        return this;
    }

    public GuiControl setExpandableY() {
        this.expandableY = true;
        return this;
    }

    public GuiControl setUnexpandableY() {
        this.expandableY = false;
        return this;
    }

    public GuiControl setDim(int width, int height) {
        this.preferred = new GuiSizeRule.GuiFixedDimension(width, height);
        return this;
    }

    public GuiControl setDim(GuiSizeRule dim) {
        this.preferred = dim;
        return this;
    }

    public GuiControl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean hasGui() {
        if (this.parent != null) {
            return this.parent.hasGui();
        }
        return false;
    }

    public void setParent(IGuiParent parent) {
        this.parent = parent;
    }

    public boolean isParent(IGuiParent parent) {
        if (this.parent == parent) {
            return true;
        }
        return this.parent.isParent(parent);
    }

    public IGuiParent getParent() {
        return this.parent;
    }

    public IGuiIntegratedParent getIntegratedParent() {
        return this.parent.getIntegratedParent();
    }

    public boolean isExpandableX() {
        return this.expandableX;
    }

    public boolean isExpandableY() {
        return this.expandableY;
    }

    public String getNestedName() {
        if (this.getParent() instanceof GuiControl) {
            return ((GuiControl)((Object)this.getParent())).getNestedName() + "." + this.name;
        }
        return this.name;
    }

    public boolean hasLayer() {
        if (this.parent instanceof GuiControl) {
            return ((GuiControl)((Object)this.parent)).hasLayer();
        }
        return false;
    }

    public GuiLayer getLayer() {
        if (this.parent instanceof GuiControl) {
            return ((GuiControl)((Object)this.parent)).getLayer();
        }
        throw new RuntimeException("Invalid layer control");
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiStyle getStyle() {
        if (this.parent instanceof GuiControl) {
            return ((GuiControl)((Object)this.parent)).getStyle();
        }
        throw new RuntimeException("Invalid layer control");
    }

    public abstract void init();

    public abstract void closed();

    public abstract void tick();

    public boolean is(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    public boolean is(String ... name) {
        for (int i = 0; i < name.length; ++i) {
            if (!this.name.equalsIgnoreCase(name[i])) continue;
            return true;
        }
        return false;
    }

    public Rect createChildRect(GuiChildControl child, Rect contentRect, double scale, double xOffset, double yOffset) {
        return contentRect.child(child.rect, scale, xOffset, yOffset);
    }

    public abstract void flowX(int var1, int var2);

    public abstract void flowY(int var1, int var2, int var3);

    public void reflow() {
        if (this.parent != null) {
            this.parent.reflow();
        }
    }

    protected int minWidth(int availableWidth) {
        return -1;
    }

    public final int getMinWidth(int availableWidth) {
        int minWidth;
        if (this.preferred != null && (minWidth = this.preferred.minWidth(this, availableWidth)) != -1) {
            return minWidth;
        }
        return this.minWidth(availableWidth);
    }

    protected abstract int preferredWidth(int var1);

    public final int getPreferredWidth(int availableWidth) {
        int prefWidth;
        if (this.preferred != null && (prefWidth = this.preferred.preferredWidth(this, availableWidth)) != -1) {
            return prefWidth;
        }
        return this.preferredWidth(availableWidth);
    }

    protected int maxWidth(int availableWidth) {
        return -1;
    }

    public final int getMaxWidth(int availableWidth) {
        int maxWidth;
        if (this.preferred != null && (maxWidth = this.preferred.maxWidth(this, availableWidth)) != -1) {
            return maxWidth;
        }
        return this.maxWidth(availableWidth);
    }

    protected int minHeight(int width, int availableHeight) {
        return -1;
    }

    public final int getMinHeight(int width, int availableHeight) {
        int minHeight;
        if (this.preferred != null && (minHeight = this.preferred.minHeight(this, width, availableHeight)) != -1) {
            return minHeight;
        }
        return this.minHeight(width, availableHeight);
    }

    protected abstract int preferredHeight(int var1, int var2);

    public final int getPreferredHeight(int width, int availableHeight) {
        int prefHeight;
        if (this.preferred != null && (prefHeight = this.preferred.preferredHeight(this, width, availableHeight)) != -1) {
            return prefHeight;
        }
        return this.preferredHeight(width, availableHeight);
    }

    protected int maxHeight(int width, int availableHeight) {
        return -1;
    }

    public final int getMaxHeight(int width, int availableHeight) {
        int maxHeight;
        if (this.preferred != null && (maxHeight = this.preferred.maxHeight(this, width, availableHeight)) != -1) {
            return maxHeight;
        }
        return this.maxHeight(width, availableHeight);
    }

    public Rect toLayerRect(Rect rect) {
        return this.getParent().toLayerRect(this, rect);
    }

    public Rect toScreenRect(Rect rect) {
        return this.getParent().toScreenRect(this, rect);
    }

    public boolean testForDoubleClick(Rect rect, double x, double y, int button) {
        return false;
    }

    public boolean isInteractable() {
        return this.enabled && this.visible;
    }

    public void mouseMoved(Rect rect, double x, double y) {
    }

    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        return false;
    }

    public boolean mouseDoubleClicked(Rect rect, double x, double y, int button) {
        return this.mouseClicked(rect, x, y, button);
    }

    public void mouseReleased(Rect rect, double x, double y, int button) {
    }

    public void mouseDragged(Rect rect, double x, double y, int button, double dragX, double dragY, double time) {
    }

    public boolean mouseScrolled(Rect rect, double x, double y, double delta) {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return false;
    }

    public void looseFocus() {
    }

    public void raiseEvent(GuiEvent event) {
        if (this.parent != null) {
            this.parent.raiseEvent(event);
        }
    }

    public abstract ControlFormatting getControlFormatting();

    @OnlyIn(value=Dist.CLIENT)
    public int getContentOffset() {
        return this.getStyle().getContentOffset(this.getControlFormatting());
    }

    public GuiTooltipEvent getTooltipEvent(Rect rect, double x, double y) {
        String langTooltip;
        List<Component> toolTip = this.getTooltip();
        if (this.customTooltip != null) {
            if (toolTip == null) {
                toolTip = this.customTooltip;
            } else {
                toolTip.addAll(this.customTooltip);
            }
        }
        if (toolTip == null && (langTooltip = GuiControl.translateOrDefault(this.getNestedName() + ".tooltip", null)) != null) {
            toolTip = new TextBuilder(langTooltip).build();
        }
        if (toolTip != null) {
            return new GuiTooltipEvent(this, toolTip);
        }
        return null;
    }

    public List<Component> getTooltip() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
        return display;
    }

    @OnlyIn(value=Dist.CLIENT)
    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        return display;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, GuiChildControl control, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        int height;
        int width;
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        Rect rectCopy = null;
        if (!this.enabled) {
            rectCopy = controlRect.copy();
        }
        if (control == null) {
            width = (int)controlRect.getWidth();
            height = (int)controlRect.getHeight();
        } else {
            width = control.getWidth();
            height = control.getHeight();
        }
        GuiStyle style = this.getStyle();
        ControlFormatting formatting = this.getControlFormatting();
        PoseStack pose = graphics.m_280168_();
        this.getBorder(style, style.get(formatting.border)).render(pose, 0.0, 0.0, width, height);
        int borderWidth = style.getBorder(formatting.border);
        this.getBackground(style, style.get(formatting.face, this.enabled && realRect.inside(mouseX, mouseY))).render(pose, borderWidth, borderWidth, width -= borderWidth * 2, height -= borderWidth * 2);
        controlRect.shrink((double)borderWidth * scale);
        this.renderContent(graphics, control, formatting, borderWidth, controlRect, realRect, scale, mouseX, mouseY);
        if (!this.enabled) {
            realRect.scissor();
            style.disabled.render(pose, realRect, rectCopy);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, GuiChildControl control, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        PoseStack pose = graphics.m_280168_();
        controlRect.shrink((double)formatting.padding * scale);
        if (!this.enabled) {
            pose.m_85836_();
        }
        pose.m_252880_((float)(borderWidth + formatting.padding), (float)(borderWidth + formatting.padding), 0.0f);
        this.renderContent(graphics, control, controlRect, controlRect.intersection(realRect), scale, mouseX, mouseY);
        if (!this.enabled) {
            pose.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, GuiChildControl control, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        this.renderContent(graphics, control, controlRect, mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void renderContent(GuiGraphics var1, GuiChildControl var2, Rect var3, int var4, int var5);

    public Player getPlayer() {
        return this.parent.getPlayer();
    }

    public static MutableComponent translatable(String text) {
        return Component.m_237113_((String)GuiControl.translate(text));
    }

    public static MutableComponent translatable(String text, Object ... parameters) {
        return Component.m_237113_((String)GuiControl.translate(text, parameters));
    }

    public static String translate(String text) {
        return LanguageUtils.translate(text);
    }

    public static String translate(String text, Object ... parameters) {
        return LanguageUtils.translate(text, parameters);
    }

    public static String translateOrDefault(String text, String defaultText) {
        return LanguageUtils.translateOr(text, defaultText);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(SoundInstance sound) {
        Minecraft.m_91087_().m_91106_().m_120367_(sound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(Holder.Reference<SoundEvent> sound) {
        GuiControl.playSound((SoundEvent)sound.m_203334_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(SoundEvent event) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)event, (float)1.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(SoundEvent event, float volume, float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)event, (float)pitch, (float)volume));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(Holder.Reference<SoundEvent> event, float volume, float pitch) {
        GuiControl.playSound((SoundEvent)event.m_203334_(), volume, pitch);
    }
}

