/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.style.display;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.resources.ResourceLocation;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.style.display.DisplayTexture;

public class DisplayTextureRepeat
extends DisplayTexture {
    public int w;
    public int h;

    public DisplayTextureRepeat() {
    }

    public DisplayTextureRepeat(ResourceLocation location, int u, int v, int width, int height) {
        super(location, u, v);
        this.w = width;
        this.h = height;
    }

    @Override
    public void render(PoseStack pose, double x, double y, double width, double height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.location);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int renderedX = 0;
        while ((double)renderedX < width) {
            int renderedY = 0;
            int renderedWidth = Math.min(this.w, (int)width - renderedX);
            while ((double)renderedY < height) {
                int renderedHeight = Math.min(this.h, (int)height - renderedY);
                GuiRenderHelper.textureRect(pose, (int)x + renderedX, renderedY, (int)y + renderedWidth, renderedHeight, this.u, this.v, this.u + renderedWidth, this.v + renderedHeight);
                renderedY += renderedHeight;
            }
            renderedX += renderedWidth;
        }
    }
}

