/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CreativeNetworkPacket;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeNetwork {
    private final HashMap<Class<? extends CreativePacket>, CreativeNetworkPacket> packetTypes = new HashMap();
    private final Logger logger;
    private int id = 0;
    public final SimpleChannel instance;

    @OnlyIn(value=Dist.CLIENT)
    private static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public CreativeNetwork(int version, Logger logger, ResourceLocation location) {
        this.logger = logger;
        this.instance = ChannelBuilder.named((ResourceLocation)location).networkProtocolVersion(version).acceptedVersions((x, y) -> x == Channel.VersionTest.Status.PRESENT && y == version).simpleChannel();
        this.logger.debug("Created network " + location);
    }

    public <T extends CreativePacket> void registerType(Class<T> classType, Supplier<T> supplier) {
        CreativeNetworkPacket handler = new CreativeNetworkPacket(classType, supplier);
        this.instance.messageBuilder(classType, this.id).encoder((message, buffer) -> handler.write((Object)message, (FriendlyByteBuf)buffer)).decoder(buffer -> handler.read((FriendlyByteBuf)buffer)).consumerMainThread((message, ctx) -> {
            try {
                message.execute((Player)(ctx.getSender() == null ? CreativeNetwork.getClientPlayer() : ctx.getSender()));
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }).add();
        this.packetTypes.put(classType, handler);
        ++this.id;
    }

    public CreativeNetworkPacket getPacketType(Class<? extends CreativePacket> clazz) {
        return this.packetTypes.get(clazz);
    }

    public void sendToServer(CreativePacket message) {
        this.instance.send((Object)message, PacketDistributor.SERVER.noArg());
    }

    public void sendToClient(CreativePacket message, ServerPlayer player) {
        this.instance.send((Object)message, PacketDistributor.PLAYER.with((Object)player));
    }

    public void sendToClient(CreativePacket message, Level level, BlockPos pos) {
        if (level instanceof ISubLevel) {
            this.sendToClientTracking(message, ((ISubLevel)level).getHolder());
        } else {
            this.sendToClient(message, level.m_46745_(pos));
        }
    }

    public void sendToClient(CreativePacket message, LevelChunk chunk) {
        this.instance.send((Object)message, PacketDistributor.TRACKING_CHUNK.with((Object)chunk));
    }

    public void sendToClientTracking(CreativePacket message, Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            this.sendToClientTracking(message, sub.getHolder());
        } else {
            this.instance.send((Object)message, PacketDistributor.TRACKING_ENTITY.with((Object)entity));
        }
    }

    public void sendToClientTrackingAndSelf(CreativePacket message, Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            this.sendToClientTrackingAndSelf(message, sub.getHolder());
        } else {
            this.instance.send((Object)message, PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)entity));
        }
    }

    public void sendToClientAll(MinecraftServer server, CreativePacket message) {
        this.instance.send((Object)message, PacketDistributor.ALL.noArg());
    }
}

