/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.model;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.client.render.model.CreativeBakedModel;
import team.creative.creativecore.client.render.model.CreativeBlockModel;
import team.creative.creativecore.client.render.model.CreativeItemBoxModel;
import team.creative.creativecore.common.util.math.base.Facing;

public class CreativeBakedBoxModel
extends CreativeBakedModel {
    public static Minecraft mc = Minecraft.m_91087_();
    public CreativeBlockModel block;
    public ItemOverrides customOverride = new ItemOverrides(){

        public BakedModel m_173464_(BakedModel original, ItemStack stack, ClientLevel level, LivingEntity entity, int p_173469_) {
            CreativeBakedBoxModel.this.renderedStack = stack;
            return super.m_173464_(original, stack, level, entity, p_173469_);
        }
    };

    public static List<BakedQuad> compileBoxes(List<? extends RenderBox> boxes, Facing side, RenderType layer, Random rand, boolean item) {
        if (side == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<BakedQuad> baked = new ArrayList<BakedQuad>();
        for (int i = 0; i < boxes.size(); ++i) {
            RenderBox box = boxes.get(i);
            if (!box.renderSide(side)) continue;
            BlockState state = Blocks.f_50016_.m_49966_();
            if (box.state != null) {
                state = box.state;
            }
            BakedModel blockModel = mc.m_91289_().m_110910_(state);
            int defaultColor = -1;
            if (item) {
                defaultColor = mc.getItemColors().m_92676_(new ItemStack((ItemLike)state.m_60734_()), defaultColor);
            }
            baked.addAll(box.getBakedQuad(null, null, box.getOffset(), state, blockModel, side, layer, rand, true, defaultColor));
        }
        return baked;
    }

    public CreativeBakedBoxModel(ModelResourceLocation location, CreativeItemBoxModel item, CreativeBlockModel block) {
        super(location, item);
        this.block = block;
    }

    public List<Pair<BakedModel, RenderType>> getLayerModels(ItemStack itemStack, boolean fabulous) {
        return super.getLayerModels(itemStack, fabulous);
    }

    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData modelData) {
        if (this.block != null) {
            return this.block.getModelData(level, pos, state, modelData);
        }
        return modelData;
    }

    @Override
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, @NotNull Random rand, @NotNull IModelData extraData) {
        Facing facing = Facing.get(direction);
        if (state != null) {
            if (this.block != null) {
                return CreativeBakedBoxModel.compileBoxes(this.block.getBoxes(state, extraData, rand), facing, MinecraftForgeClient.getRenderType(), rand, false);
            }
            return Collections.EMPTY_LIST;
        }
        if (this.renderedStack == null || this.renderedStack.m_41619_()) {
            return Collections.EMPTY_LIST;
        }
        List<BakedQuad> cached = ((CreativeItemBoxModel)this.item).getCachedModel(facing, MinecraftForgeClient.getRenderType(), this.renderedStack, false);
        if (cached != null) {
            return cached;
        }
        List<? extends RenderBox> boxes = ((CreativeItemBoxModel)this.item).getBoxes(this.renderedStack, MinecraftForgeClient.getRenderType());
        if (boxes != null) {
            cached = CreativeBakedBoxModel.compileBoxes(boxes, facing, MinecraftForgeClient.getRenderType(), rand, true);
            ((CreativeItemBoxModel)this.item).saveCachedModel(facing, MinecraftForgeClient.getRenderType(), cached, this.renderedStack, false);
            return cached;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    @Deprecated
    public List<BakedQuad> m_6840_(BlockState state, Direction direction, Random rand) {
        return this.getQuads(state, direction, rand, (IModelData)EmptyModelData.INSTANCE);
    }
}

