/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.matrix;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3d;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.OBB;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public interface IVecOrigin {
    public double offX();

    public double offY();

    public double offZ();

    public double rotX();

    public double rotY();

    public double rotZ();

    public double offXLast();

    public double offYLast();

    public double offZLast();

    public double rotXLast();

    public double rotYLast();

    public double rotZLast();

    public boolean isRotated();

    public void offX(double var1);

    public void offY(double var1);

    public void offZ(double var1);

    public void off(double var1, double var3, double var5);

    public void rotX(double var1);

    public void rotY(double var1);

    public void rotZ(double var1);

    public void rot(double var1, double var3, double var5);

    public Vec3d center();

    public void setCenter(Vec3d var1);

    public Matrix3 rotation();

    public Matrix3 rotationInv();

    public Vec3d translation();

    public void tick();

    public IVecOrigin getParent();

    default public double translationCombined(Axis axis) {
        return this.translation().get(axis);
    }

    default public void onlyRotateWithoutCenter(Vec3d vec) {
        this.rotation().transform(vec);
    }

    default public BlockPos transformPointToWorld(BlockPos pos) {
        Vec3d vec = new Vec3d((Vec3i)pos);
        this.transformPointToWorld(vec);
        return vec.toBlockPos();
    }

    default public BlockPos transformPointToFakeWorld(BlockPos pos) {
        Vec3d vec = new Vec3d((Vec3i)pos);
        this.transformPointToFakeWorld(vec);
        return vec.toBlockPos();
    }

    default public void transformPointToWorld(Vec3d vec) {
        vec.sub(this.center());
        this.rotation().transform(vec);
        vec.add(this.center());
        vec.add(this.translation());
    }

    default public void transformPointToFakeWorld(Vec3d vec) {
        vec.sub(this.translation());
        vec.sub(this.center());
        this.rotationInv().transform(vec);
        vec.add(this.center());
    }

    default public Vector3d transformPointToWorld(Vector3d vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToWorld(real);
        return new Vector3d(real.x, real.y, real.z);
    }

    default public Vector3d transformPointToFakeWorld(Vector3d vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToFakeWorld(real);
        return new Vector3d(real.x, real.y, real.z);
    }

    default public Vec3 transformPointToWorld(Vec3 vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToWorld(real);
        return new Vec3(real.x, real.y, real.z);
    }

    default public Vec3 transformPointToFakeWorld(Vec3 vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToFakeWorld(real);
        return new Vec3(real.x, real.y, real.z);
    }

    default public AABB getAxisAlignedBox(AABB box) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            Vec3d vec = BoxCorner.values()[i].get(box);
            this.transformPointToWorld(vec);
            minX = Math.min(minX, vec.x);
            minY = Math.min(minY, vec.y);
            minZ = Math.min(minZ, vec.z);
            maxX = Math.max(maxX, vec.x);
            maxY = Math.max(maxY, vec.y);
            maxZ = Math.max(maxZ, vec.z);
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    default public OBB getOrientatedBox(AABB box) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            Vec3d vec = BoxCorner.values()[i].get(box);
            this.transformPointToFakeWorld(vec);
            minX = Math.min(minX, vec.x);
            minY = Math.min(minY, vec.y);
            minZ = Math.min(minZ, vec.z);
            maxX = Math.max(maxX, vec.x);
            maxY = Math.max(maxY, vec.y);
            maxZ = Math.max(maxZ, vec.z);
        }
        return new OBB(this, minX, minY, minZ, maxX, maxY, maxZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void setupRenderingInternal(PoseStack matrixStack, Entity entity, float partialTicks) {
        double rotX = this.rotXLast() + (this.rotX() - this.rotXLast()) * (double)partialTicks;
        double rotY = this.rotYLast() + (this.rotY() - this.rotYLast()) * (double)partialTicks;
        double rotZ = this.rotZLast() + (this.rotZ() - this.rotZLast()) * (double)partialTicks;
        double offX = this.offXLast() + (this.offX() - this.offXLast()) * (double)partialTicks;
        double offY = this.offYLast() + (this.offY() - this.offYLast()) * (double)partialTicks;
        double offZ = this.offZLast() + (this.offZ() - this.offZLast()) * (double)partialTicks;
        Vec3d rotationCenter = this.center();
        matrixStack.m_85837_(offX, offY, offZ);
        matrixStack.m_85837_(rotationCenter.x, rotationCenter.y, rotationCenter.z);
        GL11.glRotated((double)rotX, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rotY, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotZ, (double)0.0, (double)0.0, (double)1.0);
        matrixStack.m_85837_(-rotationCenter.x, -rotationCenter.y, -rotationCenter.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void setupRendering(PoseStack matrixStack, Entity entity, float partialTicks) {
        this.setupRenderingInternal(matrixStack, entity, partialTicks);
    }

    default public boolean hasChanged() {
        return this.offXLast() != this.offX() || this.offYLast() != this.offY() || this.offZLast() != this.offZ() || this.rotXLast() != this.rotX() || this.rotYLast() != this.rotY() || this.rotZLast() != this.rotZ();
    }
}

