/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiRenderHelper {
    private static final Minecraft mc = Minecraft.func_71410_x();

    public static FontRenderer getFont() {
        return GuiRenderHelper.mc.field_71466_p;
    }

    public static void drawItemStack(MatrixStack matrix, ItemStack stack) {
        boolean flag;
        ItemRenderer renderer = mc.func_175599_af();
        RenderSystem.pushMatrix();
        mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        mc.func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).setBlurMipmap(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IBakedModel bakedmodel = renderer.func_184393_a(stack, (World)null, (LivingEntity)null);
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        matrix.func_227860_a_();
        Matrix4f m = matrix.func_227866_c_().func_227870_a_();
        Vector4f vec = new Vector4f();
        vec.setW(1.0f);
        vec.func_229372_a_(m);
        float shrink = 0.0625f;
        m.func_226597_a_(new Vector3f(-vec.func_195910_a() + vec.func_195910_a() * shrink, -vec.func_195913_b() - vec.func_195913_b() * shrink, -vec.func_195914_c() + vec.func_195914_c() * shrink));
        renderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrix, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        matrix.func_227865_b_();
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    public static void drawStringCentered(MatrixStack stack, String text, float width, float height, int color, boolean shadow) {
        int dotWith;
        int textWidth = GuiRenderHelper.mc.field_71466_p.func_78256_a(text);
        if ((float)textWidth > width && textWidth > (dotWith = GuiRenderHelper.mc.field_71466_p.func_78256_a("..."))) {
            int charWidth;
            StringBuilder builder = new StringBuilder();
            textWidth = 0;
            for (int i = 0; i < text.length() && (float)((charWidth = GuiRenderHelper.mc.field_71466_p.func_78256_a("" + text.charAt(i))) + textWidth + dotWith) < width; ++i) {
                builder.append(text.charAt(i));
                textWidth += charWidth;
            }
            text = builder.toString() + "...";
        }
        FontRenderer fontRenderer = GuiRenderHelper.mc.field_71466_p;
        float f = width / 2.0f - (float)(GuiRenderHelper.mc.field_71466_p.func_78256_a(text) / 2);
        float f2 = height / 2.0f;
        GuiRenderHelper.mc.field_71466_p.getClass();
        fontRenderer.func_238405_a_(stack, text, f, f2 - (float)(9 / 2), color);
    }

    public static void fillGradient(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiRenderHelper.fillGradient(matrixStack.func_227866_c_().func_227870_a_(), bufferbuilder, x1, y1, x2, y2, 0, colorFrom, colorTo);
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void fillGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int z, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.func_227888_a_(matrix, (float)x2, (float)y1, (float)z).func_227885_a_(f1, f2, f3, f).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y1, (float)z).func_227885_a_(f1, f2, f3, f).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y2, (float)z).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        builder.func_227888_a_(matrix, (float)x2, (float)y2, (float)z).func_227885_a_(f5, f6, f7, f4).func_181675_d();
    }
}

