/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiLabel
extends GuiControl {
    protected CompiledText text;
    public Align align;

    public GuiLabel(String name, int x, int y) {
        super(name, x, y, 1, 10);
        if (this.text == null) {
            this.text = CompiledText.createAnySize();
        }
    }

    protected void updateDimension() {
        if (this.getParent() != null) {
            this.setWidth(this.getPreferredWidth());
            this.setHeight(this.getPreferredHeight());
        }
    }

    public GuiLabel setTitle(ITextComponent component) {
        this.text.setText(component);
        if (this.getParent() != null) {
            this.initiateLayoutUpdate();
        }
        return this;
    }

    public GuiLabel setTitle(List<ITextComponent> components) {
        this.text.setText(components);
        if (this.getParent() != null) {
            this.initiateLayoutUpdate();
        }
        return this;
    }

    @Override
    public void init() {
        this.updateDimension();
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(MatrixStack matrix, Rect rect, int mouseX, int mouseY) {
        this.text.render(matrix);
    }

    @Override
    public void setWidthLayout(int width) {
        int offset = this.getContentOffset();
        this.text.setDimension(width - offset * 2, Integer.MAX_VALUE);
        this.text.calculateDimensions();
        this.setWidth(this.text.usedWidth + offset * 2);
        this.setHeight(this.text.usedHeight + offset * 2);
    }

    @Override
    public int getMinWidth() {
        return 10;
    }

    @Override
    public int getPreferredWidth() {
        return this.text.getTotalWidth() + this.getContentOffset() * 2;
    }

    @Override
    public void setHeightLayout(int height) {
        this.text.setMaxHeight(height - this.getContentOffset() * 2);
        this.setHeight(height);
    }

    @Override
    public int getMinHeight() {
        Minecraft.func_71410_x().field_71466_p.getClass();
        return 9 + this.getContentOffset() * 2;
    }

    @Override
    public int getPreferredHeight() {
        return this.text.getTotalHeight() + this.getContentOffset() * 2;
    }
}

