/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import net.minecraft.util.math.AxisAlignedBB;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.collision.CollisionCoordinator;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.transformation.BooleanRotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class BoxUtils {
    public static boolean equals(double a, double b, double deviation) {
        return a == b ? true : Math.abs(a - b) < deviation;
    }

    public static boolean greaterEquals(double a, double b, double deviation) {
        return a >= (b > 0.0 ? b - deviation : b + deviation);
    }

    public static boolean insideRect(double one, double two, double minOne, double minTwo, double maxOne, double maxTwo) {
        return one > minOne && one < maxOne && two > minTwo && two < maxTwo;
    }

    private static double lengthIgnoreAxis(Vec3d vec, Axis axis) {
        switch (axis) {
            case X: {
                return Math.sqrt(vec.y * vec.y + vec.z * vec.z);
            }
            case Y: {
                return Math.sqrt(vec.x * vec.x + vec.z * vec.z);
            }
            case Z: {
                return Math.sqrt(vec.x * vec.x + vec.y * vec.y);
            }
        }
        return 0.0;
    }

    private static void includeMaxRotationInBox(IncludeBox box, Vec3d vec, Axis axis, CollisionCoordinator coordinator) {
        Facing facing;
        int quarterRotation;
        double rotation = coordinator.getRotationDegree(axis);
        if (rotation == 0.0) {
            return;
        }
        Matrix3 matrix = coordinator.getRotationMatrix(axis);
        Double length = null;
        BooleanRotation state = BooleanRotation.get(axis, vec);
        boolean positive = rotation > 0.0;
        if (rotation >= 90.0) {
            for (quarterRotation = 90; (double)quarterRotation <= Math.abs(rotation) && quarterRotation < 360; quarterRotation += 90) {
                Facing facing2 = facing = positive ? state.clockwiseMaxFacing() : state.counterMaxClockwiseFacing();
                if (length == null) {
                    length = BoxUtils.lengthIgnoreAxis(vec, axis);
                }
                box.include(facing, length);
                if (coordinator.translation != null) {
                    box.include(facing, length + coordinator.translation.get(facing.axis));
                }
                state = state.clockwise();
            }
        }
        matrix.transform(vec);
        box.include(vec);
        if (quarterRotation <= 360 && !state.is(vec)) {
            Facing facing3 = facing = positive ? state.clockwiseMaxFacing() : state.counterMaxClockwiseFacing();
            if (length == null) {
                length = BoxUtils.lengthIgnoreAxis(vec, axis);
            }
            box.include(facing, length);
            if (coordinator.translation != null) {
                box.include(facing, length + coordinator.translation.get(facing.axis));
            }
        }
    }

    public static AxisAlignedBB getRotatedSurrounding(AxisAlignedBB boundingBox, CollisionCoordinator coordinator) {
        Vec3d[] corners = BoxUtils.getRotatedCorners(boundingBox, coordinator.origin);
        IncludeBox bb = new IncludeBox();
        for (int i = 0; i < corners.length; ++i) {
            Vec3d vec = corners[i];
            bb.include(vec);
            if (coordinator.hasOnlyTranslation()) {
                vec.add(coordinator.translation);
                bb.include(vec);
                continue;
            }
            BoxUtils.includeMaxRotationInBox(bb, new Vec3d(vec), Axis.X, coordinator);
            BoxUtils.includeMaxRotationInBox(bb, new Vec3d(vec), Axis.Y, coordinator);
            BoxUtils.includeMaxRotationInBox(bb, new Vec3d(vec), Axis.Z, coordinator);
            coordinator.transform(vec, 1.0);
            bb.include(vec);
        }
        return bb.getAxisBB();
    }

    public static Vec3d[] getRotatedCorners(AxisAlignedBB box, IVecOrigin origin) {
        return null;
    }

    public static Vec3d[] getOuterCorner(Facing facing, IVecOrigin origin, AxisAlignedBB box, double minOne, double minTwo, double maxOne, double maxTwo) {
        return null;
    }

    private static class IncludeBox {
        public double minX = Double.MAX_VALUE;
        public double minY = Double.MAX_VALUE;
        public double minZ = Double.MAX_VALUE;
        public double maxX = -1.7976931348623157E308;
        public double maxY = -1.7976931348623157E308;
        public double maxZ = -1.7976931348623157E308;

        public void include(Vec3d vec) {
            this.minX = Math.min(this.minX, vec.x);
            this.minY = Math.min(this.minY, vec.y);
            this.minZ = Math.min(this.minZ, vec.z);
            this.maxX = Math.max(this.maxX, vec.x);
            this.maxY = Math.max(this.maxY, vec.y);
            this.maxZ = Math.max(this.maxZ, vec.z);
        }

        public void include(Facing facing, double value) {
            switch (facing) {
                case EAST: {
                    this.maxX = Math.max(this.maxX, value);
                    break;
                }
                case WEST: {
                    this.minX = Math.min(this.minX, value);
                    break;
                }
                case UP: {
                    this.maxY = Math.max(this.maxY, value);
                    break;
                }
                case DOWN: {
                    this.minY = Math.min(this.minY, value);
                    break;
                }
                case SOUTH: {
                    this.maxZ = Math.max(this.maxZ, value);
                    break;
                }
                case NORTH: {
                    this.minZ = Math.min(this.minZ, value);
                }
            }
        }

        public AxisAlignedBB getAxisBB() {
            return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }
}

