/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.ITickList;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.client.render.world.IRenderChunkSupplier;
import team.creative.creativecore.common.world.ChunkProviderFake;
import team.creative.creativecore.common.world.IOrientatedWorld;

public abstract class CreativeWorld
extends World
implements IOrientatedWorld {
    public Entity parent;
    @OnlyIn(value=Dist.CLIENT)
    public IRenderChunkSupplier renderChunkSupplier;
    private final Map<String, MapData> mapData = Maps.newHashMap();
    private final Int2ObjectMap<Entity> entitiesById = new Int2ObjectOpenHashMap();
    private final List<AbstractClientPlayerEntity> players = Lists.newArrayList();
    private final ChunkProviderFake chunkSource;
    public boolean hasChanged = false;
    public boolean preventNeighborUpdate = false;

    protected CreativeWorld(ISpawnWorldInfo worldInfo, int radius, Supplier<IProfiler> supplier, boolean client, boolean debug, long seed) {
        super(worldInfo, CreativeCore.FAKE_DIMENSION_NAME, (DimensionType)CreativeCore.FAKE_DIMENSION, supplier, client, debug, seed);
        this.chunkSource = new ChunkProviderFake(this, radius);
    }

    public void func_190524_a(BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.preventNeighborUpdate) {
            return;
        }
        if (this.field_72995_K) {
            BlockState blockstate = this.func_180495_p(pos);
            try {
                blockstate.func_215697_a((World)this, pos, blockIn, fromPos, false);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
                crashreportcategory.func_189529_a("Source block type", () -> {
                    try {
                        return String.format("ID #%s (%s // %s)", blockIn.getRegistryName(), blockIn.func_149739_a(), blockIn.getClass().getCanonicalName());
                    }
                    catch (Throwable throwable1) {
                        return "ID #" + blockIn.getRegistryName();
                    }
                });
                CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (BlockState)blockstate);
                throw new ReportedException(crashreport);
            }
        } else {
            super.func_190524_a(pos, blockIn, fromPos);
        }
    }

    public void func_175695_a(BlockPos pos, Block block, Direction facing) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.func_175695_a(pos, block, facing);
    }

    public void func_195593_d(BlockPos pos, Block block) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.func_195593_d(pos, block);
    }

    public BlockPos transformToRealWorld(BlockPos pos) {
        return this.getOrigin().transformPointToWorld(pos);
    }

    public ITickList<Block> func_205220_G_() {
        return EmptyTickList.func_205388_a();
    }

    public ITickList<Fluid> func_205219_F_() {
        return EmptyTickList.func_205388_a();
    }

    public AbstractChunkProvider func_72863_F() {
        return this.chunkSource;
    }

    public void unload(Chunk chunk) {
        this.field_147483_b.addAll(chunk.func_177434_r().values());
        this.chunkSource.func_212863_j_().func_215571_a(chunk.func_76632_l(), false);
    }

    public void onChunkLoaded(int x, int z) {
    }

    public List<? extends PlayerEntity> func_217369_A() {
        return this.players;
    }

    public void func_184138_a(BlockPos pos, BlockState state, BlockState p_184138_3_, int p_184138_4_) {
        this.hasChanged = true;
    }

    public Entity func_73045_a(int id) {
        return (Entity)this.entitiesById.get(id);
    }

    public MapData func_217406_a(String p_217406_1_) {
        return this.mapData.get(p_217406_1_);
    }

    public void func_217399_a(MapData p_217399_1_) {
        this.mapData.put(p_217399_1_.func_195925_e(), p_217399_1_);
    }

    public int func_217395_y() {
        return 0;
    }

    public void func_175715_c(int p_175715_1_, BlockPos p_175715_2_, int p_175715_3_) {
    }
}

