/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import team.creative.creativecore.CreativeCore;

public class ClientCommandRegistry {
    private static Minecraft mc = Minecraft.m_91087_();
    private static CommandDispatcher<SharedSuggestionProvider> clientDispatcher = new CommandDispatcher();
    private static CombinedCommandDispatcher<SharedSuggestionProvider> combined = null;

    public static CommandDispatcher<SharedSuggestionProvider> getDispatcher(CommandDispatcher<SharedSuggestionProvider> vanillaDispatcher) {
        if (combined == null || !combined.is(vanillaDispatcher, clientDispatcher)) {
            combined = new CombinedCommandDispatcher<SharedSuggestionProvider>(vanillaDispatcher, clientDispatcher);
        }
        return combined;
    }

    public static LiteralCommandNode<SharedSuggestionProvider> register(LiteralArgumentBuilder<SharedSuggestionProvider> command) {
        return clientDispatcher.register(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int handleCommand(CommandSourceStack source, String command) {
        int n;
        StringReader stringreader = new StringReader(command);
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        mc.m_91307_().m_6180_(command);
        try {
            ParseResults parse = clientDispatcher.parse(stringreader, (Object)source);
            int n2 = clientDispatcher.execute(parse);
            return n2;
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            if (commandsyntaxexception.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand()) {
                int n3 = -1;
                return n3;
            }
            source.m_81352_(ComponentUtils.m_130729_((Message)commandsyntaxexception.getRawMessage()));
            if (commandsyntaxexception.getInput() != null && commandsyntaxexception.getCursor() >= 0) {
                int k = Math.min(commandsyntaxexception.getInput().length(), commandsyntaxexception.getCursor());
                MutableComponent itextcomponent1 = new TextComponent("").m_130940_(ChatFormatting.GRAY).m_130938_(p_211705_1_ -> p_211705_1_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)));
                if (k > 10) {
                    itextcomponent1.m_7220_((Component)new TextComponent("..."));
                }
                itextcomponent1.m_7220_((Component)new TextComponent(commandsyntaxexception.getInput().substring(Math.max(0, k - 10), k)));
                if (k < commandsyntaxexception.getInput().length()) {
                    MutableComponent itextcomponent2 = new TextComponent(commandsyntaxexception.getInput().substring(k)).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE});
                    itextcomponent1.m_7220_((Component)itextcomponent2);
                }
                itextcomponent1.m_7220_((Component)new TranslatableComponent("command.context.here").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
                source.m_81352_((Component)itextcomponent1);
            }
        }
        catch (Exception exception) {
            TextComponent TextComponent2;
            TextComponent itextcomponent = TextComponent2 = new TextComponent(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
            if (CreativeCore.LOGGER.isDebugEnabled()) {
                StackTraceElement[] astacktraceelement = exception.getStackTrace();
                for (int j = 0; j < Math.min(astacktraceelement.length, 3); ++j) {
                    itextcomponent.m_130946_("\n\n").m_130946_(astacktraceelement[j].getMethodName()).m_130946_("\n ").m_130946_(astacktraceelement[j].getFileName()).m_130946_(":").m_130946_(String.valueOf(astacktraceelement[j].getLineNumber()));
                }
            }
            source.m_81352_((Component)new TranslatableComponent("command.failed").m_130938_(arg_0 -> ClientCommandRegistry.lambda$handleCommand$1((MutableComponent)itextcomponent, arg_0)));
            int n4 = 0;
            return n4;
        }
        {
            n = 0;
        }
        return n;
        finally {
            mc.m_91307_().m_7238_();
        }
    }

    private static /* synthetic */ Style lambda$handleCommand$1(MutableComponent itextcomponent, Style p_211704_1_) {
        return p_211704_1_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)itextcomponent));
    }

    public static class CombinedCommandDispatcher<T>
    extends CommandDispatcher<T> {
        public final CommandDispatcher<T> first;
        public final CommandDispatcher<T> second;

        public CombinedCommandDispatcher(CommandDispatcher<T> first, CommandDispatcher<T> second) {
            this.first = first;
            this.second = second;
            RootCommandNode root = this.getRoot();
            for (CommandNode node : first.getRoot().getChildren()) {
                root.addChild(node);
            }
            for (CommandNode node : second.getRoot().getChildren()) {
                root.addChild(node);
            }
        }

        public boolean is(CommandDispatcher<T> first, CommandDispatcher<T> second) {
            return this.first == first && this.second == second;
        }
    }
}

