/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiRenderHelper {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static Font getFont() {
        return GuiRenderHelper.mc.f_91062_;
    }

    public static void drawItemStack(PoseStack mat, ItemStack stack) {
        boolean flag;
        ItemRenderer renderer = mc.m_91291_();
        mc.m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrix = RenderSystem.m_157191_();
        matrix.m_85836_();
        matrix.m_166854_(mat.m_85850_().m_85861_());
        matrix.m_85837_(0.0, 0.0, (double)(100.0f + renderer.f_115093_));
        matrix.m_85837_(8.0, 8.0, 0.0);
        matrix.m_85841_(1.0f, -1.0f, 1.0f);
        matrix.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        BakedModel bakedmodel = renderer.m_174264_(stack, (Level)null, (LivingEntity)null, 0);
        boolean bl = flag = !bakedmodel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        renderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, new PoseStack(), (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.m_69482_();
        if (flag) {
            Lighting.m_84931_();
        }
        matrix.m_85849_();
        RenderSystem.m_157182_();
    }

    public static void drawStringCentered(PoseStack stack, String text, float width, float height, int color, boolean shadow) {
        int dotWith;
        int textWidth = GuiRenderHelper.mc.f_91062_.m_92895_((String)text);
        if ((float)textWidth > width && textWidth > (dotWith = GuiRenderHelper.mc.f_91062_.m_92895_("..."))) {
            int charWidth;
            StringBuilder builder = new StringBuilder();
            textWidth = 0;
            for (int i = 0; i < ((String)text).length() && (float)((charWidth = GuiRenderHelper.mc.f_91062_.m_92895_("" + ((String)text).charAt(i))) + textWidth + dotWith) < width; ++i) {
                builder.append(((String)text).charAt(i));
                textWidth += charWidth;
            }
            text = builder.toString() + "...";
        }
        Font font = GuiRenderHelper.mc.f_91062_;
        float f = width / 2.0f - (float)(GuiRenderHelper.mc.f_91062_.m_92895_((String)text) / 2);
        float f2 = height / 2.0f;
        Objects.requireNonNull(GuiRenderHelper.mc.f_91062_);
        font.m_92750_(stack, (String)text, f, f2 - (float)(9 / 2), color);
    }

    public static void fillGradient(PoseStack matrixStack, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiRenderHelper.fillGradient(matrixStack.m_85850_().m_85861_(), bufferbuilder, x1, y1, x2, y2, 0, colorFrom, colorTo);
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void fillGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int z, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.m_85982_(matrix, (float)x2, (float)y1, (float)z).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y1, (float)z).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y2, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
        builder.m_85982_(matrix, (float)x2, (float)y2, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
    }
}

