/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.text;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.ComponentCollector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import team.creative.creativecore.client.render.text.Linebreaker;
import team.creative.creativecore.client.render.text.WidthLimitedCharSink;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.util.text.IAdvancedTextComponent;
import team.creative.creativecore.common.util.type.SingletonList;

public class CompiledText {
    private static final Font font = Minecraft.m_91087_().f_91062_;
    private int maxWidth;
    private int maxHeight;
    public int usedWidth;
    public int usedHeight;
    public int lineSpacing = 2;
    public boolean shadow = true;
    public int defaultColor = -1;
    public Align alignment = Align.LEFT;
    private List<CompiledLine> lines;
    private List<Component> original;

    public CompiledText(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        this.setText(Collections.EMPTY_LIST);
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public void setDimension(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        this.compile();
    }

    public int getMaxWidht() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setText(Component component) {
        this.setText(new SingletonList<Component>(component));
    }

    public void setText(List<Component> components) {
        this.original = components;
        this.compile();
    }

    private void compile() {
        ArrayList<MutableComponent> copy = new ArrayList<MutableComponent>();
        for (Component component : this.original) {
            copy.add(component.m_6881_());
        }
        this.lines = new ArrayList<CompiledLine>();
        this.compileNext(null, true, copy);
    }

    private CompiledLine compileNext(CompiledLine currentLine, boolean newLine, List<? extends FormattedText> components) {
        for (FormattedText formattedText : components) {
            if (newLine) {
                currentLine = new CompiledLine();
                this.lines.add(currentLine);
            }
            currentLine = this.compileNext(currentLine, formattedText);
        }
        return currentLine;
    }

    private CompiledLine compileNext(CompiledLine currentLine, boolean newLine, FormattedText component) {
        if (newLine) {
            currentLine = new CompiledLine();
            this.lines.add(currentLine);
        }
        return this.compileNext(currentLine, component);
    }

    private CompiledLine compileNext(CompiledLine currentLine, FormattedText component) {
        FormattedText next;
        ArrayList siblings = null;
        if (component instanceof Component && !((Component)component).m_7360_().isEmpty()) {
            siblings = new ArrayList(((Component)component).m_7360_());
            ((Component)component).m_7360_().clear();
        }
        if ((next = currentLine.add(component)) != null) {
            currentLine = new CompiledLine();
            this.lines.add(currentLine);
            currentLine = this.compileNext(currentLine, false, next);
        }
        if (siblings != null) {
            currentLine = this.compileNext(currentLine, false, siblings);
        }
        return currentLine;
    }

    public int getTotalHeight() {
        int height = -this.lineSpacing;
        for (CompiledLine line : this.lines) {
            height += line.height + this.lineSpacing;
        }
        return height;
    }

    public void render(PoseStack stack) {
        if (this.lines == null) {
            return;
        }
        this.usedWidth = 0;
        this.usedHeight = -this.lineSpacing;
        stack.m_85836_();
        for (CompiledLine line : this.lines) {
            switch (this.alignment) {
                case LEFT: {
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, line.width);
                    break;
                }
                case CENTER: {
                    stack.m_85836_();
                    stack.m_85837_((double)(this.maxWidth / 2 - line.width / 2), 0.0, 0.0);
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                    stack.m_85849_();
                    break;
                }
                case RIGHT: {
                    stack.m_85836_();
                    stack.m_85837_((double)(this.maxWidth - line.width), 0.0, 0.0);
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                    stack.m_85849_();
                    break;
                }
                case STRETCH: {
                    break;
                }
            }
            int height = line.height + this.lineSpacing;
            stack.m_85837_(0.0, (double)height, 0.0);
            this.usedHeight += height;
            if (this.usedHeight <= this.maxHeight) continue;
            break;
        }
        stack.m_85849_();
    }

    public FormattedTextSplit splitByWidth(FormattedText text, int width, Style style, final boolean force) {
        final WidthLimitedCharSink charSink = new WidthLimitedCharSink(width, font.m_92865_());
        final ComponentCollector head = new ComponentCollector();
        final ComponentCollector tail = new ComponentCollector();
        text.m_7451_((FormattedText.StyledContentConsumer)new FormattedText.StyledContentConsumer<FormattedText>(){

            public Optional<FormattedText> m_7164_(Style style, String text) {
                charSink.resetPosition();
                if (!StringDecomposer.m_14346_((String)text, (Style)style, (FormattedCharSink)charSink)) {
                    Linebreaker breaker = charSink.lastBreaker();
                    if (force || breaker != null) {
                        String sTail;
                        String sHead;
                        if (breaker != null) {
                            int pos = charSink.lastBreakerPos();
                            sHead = text.substring(0, pos + (breaker.includeChar && breaker.head ? 1 : 0));
                            sTail = text.substring(pos + (breaker.includeChar && !breaker.head ? 0 : 1));
                        } else {
                            sHead = text.substring(0, charSink.getPosition());
                            sTail = text.substring(charSink.getPosition());
                        }
                        if (!sHead.isEmpty()) {
                            head.m_90675_(FormattedText.m_130762_((String)sHead, (Style)style));
                        }
                        if (!sTail.isEmpty()) {
                            tail.m_90675_(FormattedText.m_130762_((String)sTail, (Style)style));
                        }
                    } else {
                        tail.m_90675_(FormattedText.m_130762_((String)text, (Style)style));
                    }
                } else if (!text.isEmpty()) {
                    head.m_90675_(FormattedText.m_130762_((String)text, (Style)style));
                }
                return Optional.empty();
            }
        }, style).orElse(null);
        return new FormattedTextSplit(head, tail);
    }

    public int getTotalWidth() {
        return this.calculateWidth(0, true, this.original);
    }

    private int calculateWidth(int width, boolean newLine, List<? extends FormattedText> components) {
        for (FormattedText formattedText : components) {
            int result = this.calculateWidth(formattedText);
            if (newLine) {
                width = Math.max(width, result);
                continue;
            }
            width += result;
        }
        return width;
    }

    private int calculateWidth(FormattedText component) {
        int width = 0;
        if (component instanceof IAdvancedTextComponent) {
            IAdvancedTextComponent advanced = (IAdvancedTextComponent)component;
            if (!advanced.isEmpty()) {
                width += advanced.getWidth(font);
            }
        } else {
            width += font.m_92852_(component);
        }
        if (component instanceof Component && !((Component)component).m_7360_().isEmpty()) {
            width += this.calculateWidth(0, false, ((Component)component).m_7360_());
        }
        return width;
    }

    public CompiledText copy() {
        CompiledText copy = new CompiledText(this.maxWidth, this.maxHeight);
        copy.alignment = this.alignment;
        copy.lineSpacing = this.lineSpacing;
        copy.shadow = this.shadow;
        ArrayList<Component> components = new ArrayList<Component>();
        for (Component component : this.original) {
            components.add((Component)component.m_6881_());
        }
        copy.setText(components);
        return copy;
    }

    public static CompiledText createAnySize() {
        return new CompiledText(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public class CompiledLine {
        private List<FormattedText> components = new ArrayList<FormattedText>();
        private int height = 0;
        private int width = 0;

        public void render(PoseStack stack) {
            int xOffset = 0;
            MultiBufferSource.BufferSource renderType = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            for (FormattedText text : this.components) {
                int height;
                int width;
                if (text instanceof IAdvancedTextComponent) {
                    width = ((IAdvancedTextComponent)text).getWidth(font);
                    height = ((IAdvancedTextComponent)text).getHeight(font);
                } else {
                    width = font.m_92852_(text);
                    Objects.requireNonNull(font);
                    height = 9;
                }
                int yOffset = 0;
                if (height < this.height) {
                    yOffset = (this.height - height) / 2;
                }
                stack.m_85836_();
                stack.m_85837_((double)xOffset, (double)yOffset, 0.0);
                if (text instanceof IAdvancedTextComponent) {
                    ((IAdvancedTextComponent)text).render(stack, font, CompiledText.this.defaultColor);
                } else {
                    font.m_92733_(Language.m_128107_().m_5536_(text), 0.0f, 0.0f, CompiledText.this.defaultColor, CompiledText.this.shadow, stack.m_85850_().m_85861_(), (MultiBufferSource)renderType, false, 0, 0xF000F0);
                    renderType.m_109911_();
                }
                stack.m_85849_();
                xOffset += width;
            }
        }

        public void updateDimension(int width, int height) {
            this.width = Math.max(width, this.width);
            this.height = Math.max(height, this.height);
        }

        public FormattedText add(FormattedText component) {
            int remainingWidth = CompiledText.this.maxWidth - this.width;
            if (component instanceof IAdvancedTextComponent) {
                IAdvancedTextComponent advanced = (IAdvancedTextComponent)component;
                if (advanced.isEmpty()) {
                    return null;
                }
                int textWidth = advanced.getWidth(font);
                if (remainingWidth > textWidth) {
                    this.components.add(advanced);
                    this.updateDimension(this.width + textWidth, advanced.getHeight(font));
                    return null;
                }
                if (advanced.canSplit()) {
                    List<IAdvancedTextComponent> remaining = advanced.split(remainingWidth, this.width == 0);
                    IAdvancedTextComponent toAdd = remaining.remove(0);
                    this.components.add(toAdd);
                    this.updateDimension(this.width + toAdd.getWidth(font), toAdd.getHeight(font));
                    if (remaining.isEmpty()) {
                        return null;
                    }
                    return remaining.get(0);
                }
                if (this.width == 0) {
                    this.components.add(advanced);
                    this.updateDimension(this.width + textWidth, advanced.getHeight(font));
                    return null;
                }
                return advanced;
            }
            int textWidth = font.m_92852_(component);
            if (remainingWidth >= textWidth) {
                this.components.add(component);
                Objects.requireNonNull(font);
                this.updateDimension(this.width + textWidth, 9);
                return null;
            }
            FormattedTextSplit split = CompiledText.this.splitByWidth(component, remainingWidth, Style.f_131099_, this.width == 0);
            if (split != null && (split.head != null || this.width == 0)) {
                if (split.head != null) {
                    int n = this.width + font.m_92852_(split.head);
                    Objects.requireNonNull(font);
                    this.updateDimension(n, 9);
                    this.components.add(split.head);
                    return split.tail;
                }
                int n = this.width + font.m_92852_(split.tail);
                Objects.requireNonNull(font);
                this.updateDimension(n, 9);
                this.components.add(split.tail);
                return null;
            }
            return component;
        }
    }

    static class FormattedTextSplit {
        public final FormattedText head;
        public final FormattedText tail;

        public FormattedTextSplit(FormattedText head, FormattedText tail) {
            this.head = head;
            this.tail = tail;
        }

        public FormattedTextSplit(ComponentCollector head, ComponentCollector tail) {
            this.head = head.m_90674_();
            this.tail = tail.m_90674_();
        }
    }
}

