/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.controls.GuiControlBasic;
import team.creative.creativecore.common.gui.controls.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.sync.LayerOpenPacket;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiSlider
extends GuiControlBasic
implements IGuiParent {
    public double maxValue;
    public double minValue;
    public double value;
    protected boolean grabbedSlider;
    public int sliderWidth = 4;
    protected GuiTextfield textfield;

    public GuiSlider(String name, int x, int y, int width, int height, double value, double min, double max) {
        super(name, x, y, width, height);
        this.minValue = min;
        this.maxValue = max;
        this.setValue(value);
    }

    public String getTextByValue() {
        return "" + (float)Math.round(this.value * 100.0) / 100.0f;
    }

    public String getTextfieldValue() {
        return this.getTextByValue();
    }

    public double getPercentage() {
        return (this.value - this.minValue) / (this.maxValue - this.minValue);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (button == 0) {
            if (this.textfield != null) {
                return this.textfield.mouseClicked(x, y, button);
            }
            GuiSlider.playSound(SoundEvents.f_12490_);
            this.grabbedSlider = true;
            this.mouseMoved(x, y);
            return true;
        }
        if (button == 1) {
            this.grabbedSlider = false;
            this.textfield = this.createTextfield();
            this.textfield.focus();
            this.textfield.setText(this.getTextfieldValue());
            this.textfield.setParent(this);
            return true;
        }
        return false;
    }

    protected GuiTextfield createTextfield() {
        return new GuiTextfield(this.getNestedName() + ".text", 0, 0, this.getWidth() - this.getContentOffset() * 2, this.getHeight() - this.getContentOffset() * 2).setFloatOnly();
    }

    public void closeTextField() {
        double value = this.value;
        try {
            this.setValue(this.textfield.parseFloat());
            GuiSlider.playSound(SoundEvents.f_12490_);
        }
        catch (NumberFormatException e) {
            this.setValue(value);
        }
        this.textfield = null;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.textfield != null) {
            if (keyCode == 257) {
                this.closeTextField();
                return true;
            }
            return this.textfield.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        if (this.textfield != null) {
            return this.textfield.charTyped(codePoint, modifiers);
        }
        return super.charTyped(codePoint, modifiers);
    }

    public void setValue(double value) {
        this.value = Math.max(this.minValue, value);
        this.value = Math.min(this.maxValue, this.value);
        if (this.getParent() != null) {
            this.raiseEvent(new GuiControlChangedEvent(this));
        }
    }

    public void mouseMoved(double x, double y) {
        if (this.grabbedSlider) {
            int width = this.getWidth() - this.getContentOffset() * 2 - this.sliderWidth;
            if (x < (double)(this.getX() + this.getContentOffset())) {
                this.value = this.minValue;
            } else if (x > (double)(this.getX() + this.getContentOffset() + width + this.sliderWidth / 2)) {
                this.value = this.maxValue;
            } else {
                int mouseOffsetX = (int)(x - (double)this.getX() - (double)this.getContentOffset() - (double)(this.sliderWidth / 2));
                this.value = (float)(this.minValue + (double)((float)((this.maxValue - this.minValue) * (double)((float)mouseOffsetX / (float)width))));
            }
            this.setValue(this.value);
        }
    }

    @Override
    public void looseFocus() {
        if (this.textfield != null) {
            this.closeTextField();
        }
        super.looseFocus();
    }

    public void mouseReleased(double x, double y, int button) {
        if (this.grabbedSlider) {
            this.grabbedSlider = false;
        }
    }

    @Override
    public boolean isContainer() {
        return this.getParent().isContainer();
    }

    public void moveBehind(GuiControl toMove, GuiControl reference) {
    }

    public void moveInFront(GuiControl toMove, GuiControl reference) {
    }

    public void moveTop(GuiControl toMove) {
    }

    public void moveBottom(GuiControl toMove) {
    }

    @Override
    public GuiLayer openLayer(LayerOpenPacket packet) {
        return this.getParent().openLayer(packet);
    }

    @Override
    public void closeTopLayer() {
        this.getParent().closeTopLayer();
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.SLIDER;
    }

    protected void renderContent(PoseStack matrix, Rect rect, int mouseX, int mouseY) {
        double percent = this.getPercentage();
        int posX = (int)((double)(this.getContentWidth() - this.sliderWidth) * percent);
        GuiStyle style = this.getStyle();
        style.get(ControlFormatting.ControlStyleFace.CLICKABLE, false).render(matrix, (double)posX, 0.0, (double)this.sliderWidth, rect.getHeight());
        if (this.textfield != null) {
            this.textfield.render(matrix, rect, rect, mouseX, mouseY);
        } else {
            GuiRenderHelper.drawStringCentered(matrix, this.getTextByValue(), (float)rect.getWidth(), (float)rect.getHeight(), -1, true);
        }
    }
}

