/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.layout;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.layout.GuiHBox;

public class GuiLeftRightBox
extends GuiHBox {
    protected List<GuiControl> rightBound = new ArrayList<GuiControl>();

    public GuiLeftRightBox(String name, int x, int y, VAlign valign) {
        super(name, x, y, Align.LEFT, valign);
    }

    public GuiLeftRightBox(String name, int x, int y) {
        super(name, x, y, Align.LEFT, VAlign.TOP);
    }

    @Override
    public void clear() {
        super.clear();
        this.rightBound.clear();
    }

    public void remove(GuiControl control) {
        super.remove(control);
        this.rightBound.remove(control);
    }

    @Override
    public void remove(String ... include) {
        super.remove(include);
        this.rightBound.removeIf(x -> ArrayUtils.contains((Object[])include, (Object)x.name));
    }

    @Override
    public void removeExclude(String ... exclude) {
        super.removeExclude(exclude);
        this.rightBound.removeIf(x -> !ArrayUtils.contains((Object[])exclude, (Object)x.name));
    }

    public void addRight(GuiControl control) {
        this.add(control);
        this.rightBound.add(control);
    }

    @Override
    protected void updatePositions(int availableWidth, int xOffset) {
        if (this.align != Align.LEFT) {
            super.updatePositions(availableWidth, xOffset);
        } else {
            int leftSize = -this.spacing;
            int rightSize = -this.spacing;
            for (GuiControl control : this) {
                if (this.rightBound.contains(control)) {
                    rightSize += control.getWidth() + this.spacing;
                    continue;
                }
                leftSize += control.getWidth() + this.spacing;
            }
            int xLeft = 0;
            int xRight = availableWidth - rightSize;
            for (GuiControl control : this) {
                if (this.rightBound.contains(control)) {
                    control.setX(xRight);
                    xRight += control.getWidth() + this.spacing;
                    continue;
                }
                switch (this.align) {
                    case LEFT: {
                        control.setX(xLeft);
                        break;
                    }
                    case CENTER: {
                        control.setX(availableWidth / 2 - leftSize / 2 + xLeft);
                        break;
                    }
                    case RIGHT: {
                        control.setX(availableWidth - leftSize + xLeft);
                        break;
                    }
                    case STRETCH: {
                        break;
                    }
                }
                xLeft += control.getWidth() + this.spacing;
            }
            this.setWidth(availableWidth);
        }
    }
}

