/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.flow;

import java.util.Iterator;
import java.util.List;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.type.MarkList;

public class GuiStackY
extends GuiFlow {
    @Override
    public int minWidth(List<GuiChildControl> controls, int spacing) {
        int width = 0;
        for (GuiChildControl child : controls) {
            width = Math.max(width, child.getMinWidth());
        }
        return width;
    }

    @Override
    public int preferredWidth(List<GuiChildControl> controls, int spacing) {
        int width = 0;
        for (GuiChildControl child : controls) {
            width = Math.max(width, child.getPreferredWidth());
        }
        return width;
    }

    @Override
    public int minHeight(List<GuiChildControl> controls, int spacing) {
        int height = -spacing;
        boolean has = false;
        for (GuiChildControl child : controls) {
            int min = child.getMinHeight();
            if (min != -1) {
                height += min;
                has = true;
            }
            height += spacing;
        }
        return has ? height : -1;
    }

    @Override
    public int preferredHeight(List<GuiChildControl> controls, int spacing) {
        int height = -spacing;
        for (GuiChildControl child : controls) {
            height += child.getPreferredHeight() + spacing;
        }
        return height;
    }

    @Override
    public void flowX(List<GuiChildControl> controls, int spacing, Align align, int width, int preferred) {
        boolean expandable = GuiStackY.areChildrenExpandableX(controls);
        if (align == Align.LEFT && !expandable) {
            for (GuiChildControl child : controls) {
                child.setX(0);
                child.setWidth(Math.min(width, child.getPreferredWidth()));
                child.flowX();
            }
        } else if (align == Align.STRETCH || expandable) {
            for (GuiChildControl child : controls) {
                if (child.control.isExpandableX() || align == Align.STRETCH) {
                    child.setWidth(width);
                } else {
                    child.setWidth(Math.min(width, child.getPreferredWidth()));
                }
                child.setX(0);
                child.flowX();
            }
        } else if (align == Align.RIGHT) {
            for (GuiChildControl child : controls) {
                child.setWidth(Math.min(width, child.getPreferredWidth()));
                child.setX(width - child.getWidth());
                child.flowX();
            }
        } else {
            for (GuiChildControl child : controls) {
                child.setWidth(Math.min(width, child.getPreferredWidth()));
                child.setX((int)Math.ceil((double)width / 2.0 - (double)child.getWidth() / 2.0));
                child.flowX();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void flowY(List<GuiChildControl> controls, int spacing, VAlign valign, int height, int preferred) {
        block22: {
            int available;
            block23: {
                block21: {
                    available = height - spacing * (controls.size() - 1);
                    MarkList<GuiChildControl> list = new MarkList<GuiChildControl>(controls);
                    if (height >= preferred) {
                        if (valign == VAlign.STRETCH && !GuiStackY.areChildrenExpandableY(controls)) {
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    GuiChildControl child = (GuiChildControl)iterator.next();
                                    available -= child.addHeight(Math.min(average, available));
                                    if (!child.isMaxHeight()) continue;
                                    iterator.mark();
                                }
                            }
                        } else {
                            Iterator itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiChildControl guiChildControl = (GuiChildControl)itr.next();
                                guiChildControl.setHeight(guiChildControl.getPreferredHeight());
                                if (!guiChildControl.control.isExpandableY()) {
                                    itr.mark();
                                }
                                available -= guiChildControl.getHeight();
                            }
                            if (valign == VAlign.STRETCH || GuiStackY.areChildrenExpandableY(controls)) {
                                while (available > 0 && !list.isEmpty()) {
                                    int average = (int)Math.ceil((double)available / (double)list.remaing());
                                    Iterator iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        GuiChildControl child = (GuiChildControl)iterator.next();
                                        available -= child.addHeight(Math.min(average, available));
                                        if (!child.isMaxHeight()) continue;
                                        iterator.mark();
                                    }
                                }
                            }
                        }
                    } else {
                        for (GuiChildControl guiChildControl : list) {
                            int min = guiChildControl.getMinHeight();
                            if (min != -1) {
                                available -= min;
                                guiChildControl.setHeight(min);
                                continue;
                            }
                            guiChildControl.setHeight(0);
                        }
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiChildControl child = (GuiChildControl)iterator.next();
                                int prefer = child.getPreferredHeight();
                                available -= child.addHeight(Math.min(average, Math.min(prefer - child.getHeight(), available)));
                                if (!child.isMaxHeight() && prefer > child.getHeight()) continue;
                                iterator.mark();
                            }
                        }
                        list.clear();
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiChildControl child = (GuiChildControl)iterator.next();
                                available -= child.addHeight(Math.min(average, available));
                                if (!child.isMaxHeight()) continue;
                                iterator.mark();
                            }
                        }
                    }
                    for (GuiChildControl guiChildControl : controls) {
                        guiChildControl.flowY();
                    }
                    if (available > 0 && valign != VAlign.TOP) break block21;
                    int y = 0;
                    for (GuiChildControl child : controls) {
                        child.setY(y);
                        y += child.getHeight() + spacing;
                    }
                    break block22;
                }
                if (valign != VAlign.BOTTOM) break block23;
                int y = height;
                for (GuiChildControl child : controls) {
                    child.setY(y -= child.getHeight());
                    y -= spacing;
                }
                break block22;
            }
            if (valign != VAlign.CENTER && valign != VAlign.STRETCH) break block22;
            int contentHeight = height - (available + spacing * (controls.size() - 1));
            int n = height / 2 - contentHeight / 2;
            for (GuiChildControl child : controls) {
                void var9_33;
                child.setY((int)var9_33);
                var9_33 += child.getHeight() + spacing;
            }
        }
    }
}

