/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.network.CreativeNetworkPacket;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeNetwork {
    private final HashMap<Class<? extends CreativePacket>, CreativeNetworkPacket> packetTypes = new HashMap();
    private final Logger logger;
    private final String version;
    private int id = 0;
    public final SimpleChannel instance;

    @OnlyIn(value=Dist.CLIENT)
    private static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public CreativeNetwork(String version, Logger logger, ResourceLocation location) {
        this.version = version;
        this.logger = logger;
        this.instance = NetworkRegistry.newSimpleChannel((ResourceLocation)location, () -> this.version, x -> true, this.version::equals);
        this.logger.debug("Created network " + location);
    }

    public <T extends CreativePacket> void registerType(Class<T> classType, Supplier<T> supplier) {
        CreativeNetworkPacket handler = new CreativeNetworkPacket(classType, supplier);
        this.instance.registerMessage(this.id, classType, (message, buffer) -> handler.write((Object)message, (FriendlyByteBuf)buffer), buffer -> handler.read((FriendlyByteBuf)buffer), (message, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> CreativeNetwork.lambda$registerType$4(message, (Supplier)ctx));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        this.packetTypes.put(classType, handler);
        ++this.id;
    }

    public CreativeNetworkPacket getPacketType(Class<? extends CreativePacket> clazz) {
        return this.packetTypes.get(clazz);
    }

    public void sendToServer(CreativePacket message) {
        this.instance.sendToServer((Object)message);
    }

    public void sendToClient(CreativePacket message, ServerPlayer player) {
        this.instance.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public void sendToClient(CreativePacket message, LevelChunk chunk) {
        this.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)message);
    }

    public void sendToClientTracking(CreativePacket message, Entity entity) {
        this.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)message);
    }

    public void sendToClientAll(CreativePacket message) {
        this.instance.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    private static /* synthetic */ void lambda$registerType$4(CreativePacket message, Supplier ctx) {
        message.execute((Player)(((NetworkEvent.Context)ctx.get()).getSender() == null ? CreativeNetwork.getClientPlayer() : ((NetworkEvent.Context)ctx.get()).getSender()));
    }
}

