/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.collision;

import javax.annotation.Nullable;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.collision.CollisionCoordinator;
import team.creative.creativecore.common.util.math.collision.CreativeVoxelShape;
import team.creative.creativecore.common.util.math.collision.OrientatedVoxelShape;
import team.creative.creativecore.common.util.math.matrix.Matrix4;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class CollidingPlane {
    public final CreativeVoxelShape bb;
    public final Facing facing;
    public final PlaneCache cache;
    protected final Vec3d origin;
    protected final Vec3d normal;
    public static final int accuracySteps = 10;

    public CollidingPlane(CreativeVoxelShape bb, Facing facing, PlaneCache cache, Vec3d[] corners, BoxCorner[] planeCorners) {
        this.bb = bb;
        this.facing = facing;
        this.cache = cache;
        this.origin = corners[planeCorners[0].ordinal()];
        Vec3d first = corners[planeCorners[1].ordinal()];
        Vec3d second = corners[planeCorners[2].ordinal()];
        this.normal = new Vec3d((first.y - this.origin.y) * (second.z - this.origin.z) - (first.z - this.origin.z) * (second.y - this.origin.y), (first.z - this.origin.z) * (second.x - this.origin.x) - (first.x - this.origin.x) * (second.z - this.origin.z), (first.x - this.origin.x) * (second.y - this.origin.y) - (first.y - this.origin.y) * (second.x - this.origin.x));
    }

    public Boolean isInFront(Vec3d vec) {
        double scalar = (vec.x - this.origin.x) * this.normal.x + (vec.y - this.origin.y) * this.normal.y + (vec.z - this.origin.z) * this.normal.z;
        if (scalar > 0.0) {
            return true;
        }
        if (scalar < 0.0) {
            return false;
        }
        return null;
    }

    public Double binarySearch(@Nullable Double value, AABB toCheck, double checkRadiusSquared, Vec3d center, CollisionCoordinator coordinator) {
        if (coordinator.isSimple) {
            Double t = this.searchBetweenSimple(value, center, new Vec3d(center), new Vec3d(), 0.0, 1.0, coordinator, 0);
            if (t != null && this.intersects(toCheck, checkRadiusSquared, center, t, coordinator)) {
                return t;
            }
            return null;
        }
        if (coordinator.hasOneRotation && !coordinator.hasTranslation) {
            Vec3d start = new Vec3d(center);
            Vec3d temp = new Vec3d();
            int halfRotations = coordinator.getNumberOfHalfRotations();
            double halfRotationSize = 1.0 / (double)halfRotations;
            Double t = this.searchBetweenSimple(value, center, start, temp, 0.0, halfRotationSize, coordinator, 0);
            if (t != null && this.intersects(toCheck, checkRadiusSquared, center, t, coordinator)) {
                return t;
            }
            start.set(center);
            coordinator.transformInverted(start, halfRotationSize);
            t = this.searchBetweenSimple(value, center, new Vec3d(center), temp, halfRotationSize, halfRotationSize * 2.0, coordinator, 0);
            if (t != null && this.intersects(toCheck, checkRadiusSquared, center, t, coordinator)) {
                return t;
            }
            return null;
        }
        Vec3d start = new Vec3d(center);
        Vec3d temp = new Vec3d();
        int halfRotations = coordinator.getNumberOfHalfRotations();
        double halfRotationSize = 1.0 / (double)halfRotations;
        for (int i = 0; i < halfRotations; ++i) {
            double startT = halfRotationSize * (double)i;
            double endT = halfRotationSize * (double)(i + 1);
            if (startT != 0.0) {
                start.set(center);
                coordinator.transformInverted(start, startT);
            }
            if (value != null && value <= startT) {
                return null;
            }
            Double t = this.searchBetweenSimple(value, center, start, temp, startT, endT, coordinator, 0);
            if (t == null || !this.intersects(toCheck, checkRadiusSquared, center, t, coordinator)) continue;
            return t;
        }
        return null;
    }

    protected Double searchBetweenSimple(@Nullable Double value, Vec3d center, Vec3d start, Vec3d temp, double startT, double endT, CollisionCoordinator coordinator, int steps) {
        if (value != null && value < startT) {
            return null;
        }
        Boolean beforeFront = this.isInFront(start);
        if (beforeFront == null) {
            return startT;
        }
        temp.set(center);
        coordinator.transformInverted(temp, endT);
        Boolean afterFront = this.isInFront(temp);
        if (afterFront == null) {
            return value != null ? Math.min(value, endT) : endT;
        }
        if (beforeFront != afterFront) {
            if (steps < 10) {
                ++steps;
                double halfT = (startT + endT) / 2.0;
                temp.set(center);
                coordinator.transformInverted(temp, halfT);
                Boolean halfFront = this.isInFront(temp);
                if (halfFront == null) {
                    return value != null ? Math.min(value, halfT) : halfT;
                }
                if (beforeFront != halfFront) {
                    return this.searchBetweenSimple(value, center, start, temp, startT, halfT, coordinator, steps);
                }
                return this.searchBetweenSimple(value, center, temp, start, halfT, endT, coordinator, steps);
            }
            return startT;
        }
        return null;
    }

    public boolean intersects(AABB toCheck, double checkRadiusSquared, Vec3d center, double t, CollisionCoordinator coordinator) {
        Vec3d cachedCenter = new Vec3d(this.cache.center);
        coordinator.origin.transformPointToWorld(cachedCenter);
        coordinator.transform(cachedCenter, t);
        cachedCenter.sub(center);
        if (cachedCenter.lengthSquared() >= checkRadiusSquared + this.cache.radiusSquared) {
            return false;
        }
        Matrix4 matrix = coordinator.getInverted(t);
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        return false;
    }

    public static CollidingPlane[] getPlanes(CreativeVoxelShape box, PlaneCache cache, CollisionCoordinator coordinator) {
        return null;
    }

    public static Facing getDirection(CollisionCoordinator coordinator, OrientatedVoxelShape box, Vec3d center) {
        return null;
    }

    public static class PlaneCache {
        public CollidingPlane[] planes;
        public final Vec3d center;
        public final double radiusSquared;

        public PlaneCache(AABB box) {
            this.radiusSquared = (box.f_82288_ * box.f_82291_ + box.f_82289_ * box.f_82292_ + box.f_82290_ * box.f_82293_) * 0.5;
            this.center = new Vec3d(box.f_82288_ + (box.f_82291_ - box.f_82288_) * 0.5, box.f_82289_ + (box.f_82292_ - box.f_82289_) * 0.5, box.f_82290_ + (box.f_82293_ - box.f_82290_) * 0.5);
        }

        public boolean isCached() {
            return this.planes != null;
        }

        public void reset() {
            this.planes = null;
        }
    }

    public static class PushCache {
        public Facing facing;
        public OrientatedVoxelShape pushBox;
        public AABB entityBox;
        public OrientatedVoxelShape entityBoxOrientated;
    }
}

