/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Material;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientMaterial;

@CreativeConfig
public class SortingList
implements List<CreativeIngredient> {
    @CreativeConfig
    public List<CreativeIngredient> entries = new ArrayList<CreativeIngredient>();
    @CreativeConfig
    public boolean isWhitelist;

    public SortingList(SortingList list) {
        this.isWhitelist = list.isWhitelist;
        this.entries = new ArrayList<CreativeIngredient>(list.entries);
    }

    public SortingList() {
        this(true);
    }

    public SortingList(boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
    }

    public boolean isBlacklist() {
        return !this.isWhitelist;
    }

    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    public void setListType(boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
    }

    public void setWhitelist() {
        this.isWhitelist = true;
    }

    public void setBlacklist() {
        this.isWhitelist = false;
    }

    public void addSortingObjects(Object ... objects) {
        for (int i = 0; i < objects.length; ++i) {
            this.addSortingObject(objects[i]);
        }
    }

    public void addSortingObject(Object object) {
        if (object instanceof CreativeIngredient) {
            this.add((CreativeIngredient)object);
            return;
        }
        CreativeIngredient info = CreativeIngredient.parse(object);
        if (info != null) {
            this.add(info);
        }
    }

    public void addSortingByBlock(Block block) {
        this.add(new CreativeIngredientBlock(block));
    }

    public void addSortingByItem(Item item) {
        this.add(new CreativeIngredientItem(item));
    }

    public void addSortingByItemStack(ItemStack stack) {
        this.add(new CreativeIngredientItemStack(stack, false));
    }

    public void addSortingByMaterial(Material material) {
        this.add(new CreativeIngredientMaterial(material));
    }

    protected boolean canBeFoundInList(Object object) {
        CreativeIngredient info = CreativeIngredient.parse(object);
        if (info == null) {
            return false;
        }
        for (CreativeIngredient ingredient : this.entries) {
            if (!ingredient.is(info)) continue;
            return true;
        }
        return false;
    }

    protected boolean canBeFoundInList(ItemStack stack) {
        for (CreativeIngredient ingredient : this.entries) {
            if (!ingredient.is(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean canPass(Object object) {
        return this.canBeFoundInList(object) == this.isWhitelist;
    }

    public boolean canPass(ItemStack stack) {
        return this.canBeFoundInList(stack) == this.isWhitelist;
    }

    @Override
    public boolean add(CreativeIngredient arg0) {
        return this.entries.add(arg0);
    }

    @Override
    public void add(int arg0, CreativeIngredient arg1) {
        this.entries.add(arg0, arg1);
    }

    @Override
    public boolean addAll(Collection<? extends CreativeIngredient> arg0) {
        return this.addAll(arg0);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends CreativeIngredient> arg1) {
        return this.addAll(arg0, arg1);
    }

    @Override
    public void clear() {
        this.entries = new ArrayList<CreativeIngredient>();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.entries.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.entries.containsAll(arg0);
    }

    @Override
    public CreativeIngredient get(int arg0) {
        return this.entries.get(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        return this.entries.indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<CreativeIngredient> iterator() {
        return this.entries.iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.entries.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<CreativeIngredient> listIterator() {
        return this.entries.listIterator();
    }

    @Override
    public ListIterator<CreativeIngredient> listIterator(int arg0) {
        return this.entries.listIterator(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.entries.remove(arg0);
    }

    @Override
    public CreativeIngredient remove(int arg0) {
        return this.entries.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.entries.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.entries.retainAll(arg0);
    }

    @Override
    public CreativeIngredient set(int index, CreativeIngredient element) {
        return this.entries.set(index, element);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public List<CreativeIngredient> subList(int fromIndex, int toIndex) {
        return this.entries.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.entries.toArray(a);
    }
}

