/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.common.blockEntity;

import com.croparia.mod.core.init.BlockEntityInit;
import com.croparia.mod.core.util.CropariaEnergyStorage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BatteryBE
extends BlockEntity {
    private final CropariaEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);

    public BatteryBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.BATTERY_BE.get(), pos, state);
    }

    private CropariaEnergyStorage createEnergy() {
        return new CropariaEnergyStorage(1000000, 10000){

            @Override
            protected void onEnergyChanged() {
                BatteryBE.this.m_6596_();
            }
        };
    }

    public void m_7651_() {
        super.m_7651_();
        this.energy.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos worldPosition, BlockState state, BatteryBE batteryBE) {
        if (!level.f_46443_) {
            BatteryBE.giveEnergy(batteryBE);
        }
    }

    private static void giveEnergy(BatteryBE batteryBE) {
        AtomicInteger capacity = new AtomicInteger(batteryBE.energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            for (Direction direction : Direction.values()) {
                boolean doContinue;
                BlockEntity be;
                if (direction == Direction.UP || direction == Direction.DOWN || (be = batteryBE.f_58857_.m_7702_(batteryBE.f_58858_.m_142300_(direction))) == null || (doContinue = be.getCapability(CapabilityEnergy.ENERGY, direction).map(handler -> {
                    if (handler.canReceive()) {
                        int received = handler.receiveEnergy(Math.min(capacity.get(), 1000), false);
                        capacity.addAndGet(-received);
                        batteryBE.energyStorage.consumeEnergy(received);
                        batteryBE.m_6596_();
                        return capacity.get() > 0;
                    }
                    return true;
                }).orElse(true).booleanValue())) continue;
                return;
            }
        }
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128441_("energyStorage")) {
            this.energyStorage.deserializeNBT(compoundTag.m_128423_("energyStorage"));
        }
    }

    public CompoundTag m_6945_(CompoundTag compoundTag) {
        super.m_6945_(compoundTag);
        compoundTag.m_128365_("energyStorage", this.energyStorage.serializeNBT());
        return compoundTag;
    }
}

