/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.common.blockEntity;

import com.croparia.mod.common.blocks.Collector;
import com.croparia.mod.core.init.BlockEntityInit;
import com.croparia.mod.core.util.CropariaEnergyStorage;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CollectorBE
extends BaseContainerBlockEntity {
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private final CropariaEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);

    public CollectorBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.COLLECTOR_BE.get(), pos, state);
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public static void tick(Level level, BlockPos worldPosition, BlockState state, CollectorBE collectorBE) {
        int area = 5;
        int range = (area - 1) / 2;
        if (!level.f_46443_ && level.m_8055_(worldPosition).m_60734_() instanceof Collector && ((Boolean)level.m_8055_(worldPosition).m_61143_((Property)Collector.POWERED)).booleanValue() && collectorBE.energyStorage.getEnergyStored() >= 10) {
            collectorBE.energyStorage.consumeEnergy(10);
            Direction direction = (Direction)level.m_8055_(worldPosition).m_61143_((Property)Collector.FACING);
            BlockPos start = worldPosition.m_142300_(direction).m_5484_(direction.m_122427_(), range);
            BlockPos end = worldPosition.m_5484_(direction, area).m_5484_(direction.m_122427_(), -range);
            BlockPos.m_121990_((BlockPos)start, (BlockPos)end).forEach(position -> {
                BlockState blockState;
                CropBlock block;
                if (level.m_8055_(position).m_60734_() instanceof CropBlock && (block = (CropBlock)(blockState = level.m_8055_(position)).m_60734_()).m_52307_(blockState)) {
                    for (ItemStack stack : Block.m_49869_((BlockState)blockState, (ServerLevel)level.m_142572_().m_129880_(level.m_46472_()), (BlockPos)position, (BlockEntity)level.m_7702_(position))) {
                        CollectorBE.addItemStackInInventory(stack, collectorBE);
                    }
                    if (level.m_8055_(position).m_60734_() instanceof BeetrootBlock) {
                        level.m_46597_(position, (BlockState)block.m_49966_().m_61124_((Property)BeetrootBlock.f_49657_, (Comparable)Integer.valueOf(1)));
                        System.out.println("deja l\u00c3\u00a0 ?!");
                    } else {
                        level.m_46597_(position, (BlockState)block.m_49966_().m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(4)));
                    }
                }
            });
        }
    }

    private CropariaEnergyStorage createEnergy() {
        return new CropariaEnergyStorage(40000, 350){

            @Override
            protected void onEnergyChanged() {
                CollectorBE.this.m_6596_();
            }
        };
    }

    public void m_7651_() {
        super.m_7651_();
        this.energy.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != Direction.NORTH) {
            return this.energy.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.inventory);
        if (compoundTag.m_128441_("energyStorage")) {
            this.energyStorage.deserializeNBT(compoundTag.m_128423_("energyStorage"));
        }
    }

    public CompoundTag m_6945_(CompoundTag compoundTag) {
        super.m_6945_(compoundTag);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.inventory);
        compoundTag.m_128365_("energyStorage", this.energyStorage.serializeNBT());
        return compoundTag;
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.collector");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new ChestMenu(MenuType.f_39959_, id, player, (Container)this, 3);
    }

    public static void addItemStackInInventory(ItemStack itemstack, CollectorBE collectorBE) {
        int i = collectorBE.m_6643_();
        ItemStack stack = itemstack;
        for (int j = 0; j < i && !stack.m_41619_(); ++j) {
            if ((collectorBE.m_8020_(j).m_41613_() >= 64 || collectorBE.m_8020_(j).m_41720_() != stack.m_41720_()) && !collectorBE.m_8020_(j).m_41619_()) continue;
            collectorBE.m_6836_(j, new ItemStack((ItemLike)stack.m_41720_(), stack.m_41613_() + collectorBE.m_8020_(j).m_41613_()));
            stack = new ItemStack((ItemLike)stack.m_41720_(), stack.m_41613_() - collectorBE.m_8020_(j).m_41613_());
        }
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        AtomicBoolean empty = new AtomicBoolean(true);
        this.inventory.stream().forEach(itemStack -> {
            if (!itemStack.m_41619_()) {
                empty.set(false);
            }
        });
        return empty.get();
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack m_7407_(int p_58330_, int p_58331_) {
        return ContainerHelper.m_18969_(this.inventory, (int)p_58330_, (int)p_58331_);
    }

    public ItemStack m_8016_(int p_58387_) {
        return ContainerHelper.m_18966_(this.inventory, (int)p_58387_);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.inventory.clear();
    }
}

