/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.common.blockEntity;

import com.croparia.mod.common.blocks.CropariaCrops;
import com.croparia.mod.core.init.BlockEntityInit;
import com.croparia.mod.core.util.CropariaEnergyStorage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CropGeneratorBE
extends BlockEntity {
    private final CropariaEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private int[] ages = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public CropGeneratorBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.GENERATOR_BE.get(), pos, state);
    }

    public void m_7651_() {
        super.m_7651_();
        this.energy.invalidate();
    }

    public static void tick(Level level, BlockPos worldPosition, BlockState state, CropGeneratorBE generatorBE) {
        if (!level.f_46443_) {
            AtomicInteger i = new AtomicInteger(0);
            BlockPos.m_121990_((BlockPos)worldPosition.m_142390_(2).m_142385_(2), (BlockPos)worldPosition.m_142383_(2).m_142386_(2)).forEach(pos -> generatorBE.createEnergyFromCrops((BlockPos)pos, generatorBE, i));
            CropGeneratorBE.giveEnergy(generatorBE);
        }
    }

    private static void giveEnergy(CropGeneratorBE generatorBE) {
        AtomicInteger capacity = new AtomicInteger(generatorBE.energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            for (Direction direction : Direction.values()) {
                boolean doContinue;
                BlockEntity be;
                if (direction != Direction.UP || (be = generatorBE.f_58857_.m_7702_(generatorBE.f_58858_.m_142300_(direction))) == null || (doContinue = be.getCapability(CapabilityEnergy.ENERGY, direction).map(handler -> {
                    if (handler.canReceive()) {
                        int received = handler.receiveEnergy(Math.min(capacity.get(), 1000), false);
                        capacity.addAndGet(-received);
                        generatorBE.energyStorage.consumeEnergy(received);
                        generatorBE.m_6596_();
                        return capacity.get() > 0;
                    }
                    return true;
                }).orElse(true).booleanValue())) continue;
                return;
            }
        }
    }

    private void createEnergyFromCrops(BlockPos pos, CropGeneratorBE generatorBE, AtomicInteger i) {
        if (this.f_58857_.m_8055_(pos).m_60734_() instanceof CropariaCrops) {
            if (generatorBE.ages[i.get()] != (Integer)this.f_58857_.m_8055_(pos).m_61143_((Property)CropariaCrops.f_52244_)) {
                this.energyStorage.addEnergy(this.getEnergyFromCrop(pos, generatorBE));
                this.m_6596_();
            }
            if (((CropariaCrops)this.f_58857_.m_8055_(pos).m_60734_()).m_52307_(this.f_58857_.m_8055_(pos))) {
                this.f_58857_.m_7731_(pos, (BlockState)this.f_58857_.m_8055_(pos).m_61124_((Property)CropariaCrops.f_52244_, (Comparable)Integer.valueOf(0)), 3);
            }
            generatorBE.ages[i.get()] = (Integer)this.f_58857_.m_8055_(pos).m_61143_((Property)CropariaCrops.f_52244_);
            i.getAndIncrement();
        }
    }

    private int getEnergyFromCrop(BlockPos pos, CropGeneratorBE generatorBE) {
        CropariaCrops block = (CropariaCrops)generatorBE.f_58857_.m_8055_(pos).m_60734_();
        int tier = block.getCrop().getTier();
        int createdEnergy = 100 * tier;
        if (block.m_52307_(generatorBE.f_58857_.m_8055_(pos))) {
            createdEnergy *= 2;
            generatorBE.f_58857_.m_7731_(pos, (BlockState)block.m_49966_().m_61124_((Property)CropariaCrops.f_52244_, (Comparable)Integer.valueOf(0)), 3);
        }
        return createdEnergy;
    }

    public void initAges() {
        AtomicInteger i = new AtomicInteger(0);
        BlockPos.m_121990_((BlockPos)this.f_58858_.m_142390_(2).m_142385_(2), (BlockPos)this.f_58858_.m_142383_(2).m_142386_(2)).forEach(pos -> {
            if (this.f_58857_.m_8055_(pos).m_60734_() instanceof CropariaCrops) {
                this.ages[i.get()] = (Integer)this.f_58857_.m_8055_(pos).m_61143_((Property)CropariaCrops.f_52244_);
            }
            i.getAndIncrement();
        });
    }

    private CropariaEnergyStorage createEnergy() {
        return new CropariaEnergyStorage(1000000, 0){

            @Override
            protected void onEnergyChanged() {
                CropGeneratorBE.this.m_6596_();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag tag) {
        this.energyStorage.deserializeNBT(tag.m_128423_("energy"));
        this.ages = tag.m_128465_("ages");
        super.m_142466_(tag);
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        tag.m_128365_("energy", this.energyStorage.serializeNBT());
        tag.m_128385_("ages", this.ages);
        return super.m_6945_(tag);
    }
}

