/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.common.blockEntity;

import com.croparia.mod.common.items.SoulJar;
import com.croparia.mod.common.menu.OneSlotMenu;
import com.croparia.mod.core.init.BlockEntityInit;
import com.croparia.mod.core.util.CropariaEnergyStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SpawnerBE
extends BaseContainerBlockEntity {
    int delay = 300;
    int wait = 0;
    private final CropariaEnergyStorage energyStorage = this.createEnergy();
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private EntityType entityType = null;

    public SpawnerBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.SPAWNER_BE.get(), pos, state);
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
        this.energy.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos worldPosition, BlockState state, SpawnerBE spawnerBE) {
        if (!level.f_46443_ && spawnerBE.m_8020_(0).m_41720_() instanceof SoulJar) {
            CompoundTag tag = spawnerBE.m_8020_(0).m_41783_();
            if (tag.m_128441_("entity")) {
                spawnerBE.entityType = (EntityType)EntityType.m_20632_((String)tag.m_128461_("entity")).get();
            }
            if (spawnerBE.entityType != null && spawnerBE.energyStorage.getEnergyStored() >= 10) {
                ++spawnerBE.wait;
                spawnerBE.energyStorage.consumeEnergy(10);
                if (spawnerBE.wait >= spawnerBE.delay) {
                    Entity entity = spawnerBE.entityType.m_20615_(level);
                    entity.m_6034_((double)worldPosition.m_123341_() + 0.5, (double)(worldPosition.m_123342_() + 1), (double)worldPosition.m_123343_() + 0.5);
                    level.m_7967_(entity);
                    spawnerBE.wait = 0;
                }
            }
        }
    }

    private CropariaEnergyStorage createEnergy() {
        return new CropariaEnergyStorage(40000, 350){

            @Override
            protected void onEnergyChanged() {
                SpawnerBE.this.m_6596_();
            }
        };
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof SoulJar;
            }
        };
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.energyStorage.deserializeNBT(compoundTag.m_128423_("energyStorage"));
        this.itemHandler.deserializeNBT(compoundTag.m_128469_("inv"));
    }

    public CompoundTag m_6945_(CompoundTag compoundTag) {
        super.m_6945_(compoundTag);
        compoundTag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        compoundTag.m_128365_("energyStorage", this.energyStorage.serializeNBT());
        return compoundTag;
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.soul_spawner");
    }

    protected AbstractContainerMenu m_6555_(int a, Inventory inventory) {
        return new OneSlotMenu(a, inventory, (Container)this, (ContainerData)new SimpleContainerData(1));
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.itemHandler.getStackInSlot(0) == ItemStack.f_41583_;
    }

    public ItemStack m_8020_(int id) {
        return this.itemHandler.getStackInSlot(0);
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        this.m_6596_();
        return this.m_8016_(p_70298_1_);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack ret = this.itemHandler.getStackInSlot(slot);
        this.m_6211_();
        return ret;
    }

    public void m_6836_(int id, ItemStack stack) {
        if (id == 0) {
            this.itemHandler.setStackInSlot(0, stack);
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
    }
}

