/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.common.blockEntity;

import com.croparia.mod.common.items.CropsSeed;
import com.croparia.mod.common.menu.TransformerMenu;
import com.croparia.mod.core.init.BlockEntityInit;
import com.croparia.mod.core.util.CropariaEnergyStorage;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TransformerBE
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{1};
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    int recipeTime;
    int recipeProgress;
    ItemStackHandler handler = new ItemStackHandler(2);
    int dropRate = 33;
    LazyOptional<?>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private final CropariaEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int a) {
            switch (a) {
                case 0: {
                    return TransformerBE.this.recipeProgress;
                }
                case 1: {
                    return TransformerBE.this.recipeTime;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TransformerBE.this.recipeProgress = value;
                    break;
                }
                case 1: {
                    TransformerBE.this.recipeTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public ItemStackHandler getHandler() {
        return this.handler;
    }

    public TransformerBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.TRANSFORMER_BE.get(), pos, state);
    }

    public ContainerData getData() {
        return this.dataAccess;
    }

    public void m_7651_() {
        super.m_7651_();
        this.energy.invalidate();
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        this.recipeProgress = compoundTag.m_128451_("RecipeProgress");
        this.recipeTime = compoundTag.m_128451_("RecipeTime");
        if (compoundTag.m_128441_("energyStorage")) {
            this.energyStorage.deserializeNBT(compoundTag.m_128423_("energyStorage"));
        }
    }

    public CompoundTag m_6945_(CompoundTag compoundTag) {
        super.m_6945_(compoundTag);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        compoundTag.m_128405_("RecipeProgress", this.recipeProgress);
        compoundTag.m_128405_("RecipeTime", this.recipeTime);
        compoundTag.m_128365_("energyStorage", this.energyStorage.serializeNBT());
        return compoundTag;
    }

    public Item getFruit(CropsSeed seed) {
        return (Item)seed.getCrop().getFruit().get();
    }

    public boolean transform(ItemStack stack) {
        if (stack.m_41720_() instanceof CropsSeed) {
            CropsSeed seed = (CropsSeed)stack.m_41720_();
            int dropRate = 50 / seed.getCrop().getTier();
            int random = this.f_58857_.f_46441_.nextInt(100);
            int cond = random - dropRate;
            if (cond < 0) {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, new ItemStack((ItemLike)this.getFruit(seed))));
            }
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    public static void tick(Level level, BlockPos worldPosition, BlockState state, TransformerBE transformerBE) {
        if (!level.f_46443_ && transformerBE.m_8020_(0).m_41720_() instanceof CropsSeed) {
            int tier = ((CropsSeed)transformerBE.m_8020_(0).m_41720_()).getCrop().getTier();
            if (transformerBE.energyStorage.getEnergyStored() >= 10) {
                Item fruit;
                ++transformerBE.recipeProgress;
                transformerBE.energyStorage.consumeEnergy(10);
                transformerBE.recipeTime = 100 * tier;
                if (transformerBE.recipeProgress >= transformerBE.recipeTime && transformerBE.canAddItem(1, fruit = (Item)((CropsSeed)transformerBE.m_8020_(0).m_41720_()).getCrop().getFruit().get())) {
                    Random rand = transformerBE.f_58857_.f_46441_;
                    int lim = transformerBE.dropRate / tier;
                    int a = rand.nextInt(100);
                    if (a < lim) {
                        transformerBE.addItem(1, fruit, 1);
                    }
                    transformerBE.m_8020_(0).m_41774_(1);
                    transformerBE.recipeProgress = 0;
                }
            } else {
                transformerBE.recipeProgress = 0;
            }
        }
    }

    private CropariaEnergyStorage createEnergy() {
        return new CropariaEnergyStorage(40000, 350){

            @Override
            protected void onEnergyChanged() {
                TransformerBE.this.m_6596_();
            }
        };
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[0].cast();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean canAddItem(int slot, Item input) {
        ItemStack actualStack = this.m_8020_(slot);
        return actualStack.m_41720_() == input ? actualStack.m_41613_() + 1 <= actualStack.m_41741_() : actualStack.m_41720_() == Items.f_41852_;
    }

    public void addItem(int slot, Item input, int count) {
        if (this.m_8020_(slot).m_41720_() != Items.f_41852_) {
            count += this.m_8020_(slot).m_41613_();
        }
        this.m_6836_(slot, new ItemStack((ItemLike)input, count));
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int id) {
        return (ItemStack)this.items.get(id);
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        return ContainerHelper.m_18969_(this.items, (int)p_70298_1_, (int)p_70298_2_);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack slotStack = (ItemStack)this.items.get(slot);
        boolean flag = !stack.m_41619_() && stack.m_41656_(slotStack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)slotStack);
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (slot == 0 && !flag) {
            this.recipeProgress = 0;
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int[] m_7071_(Direction dir) {
        if (dir == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return dir == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return dir != Direction.DOWN && slot == 0;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return dir == Direction.DOWN && slot == 1;
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.seed_recycler");
    }

    protected AbstractContainerMenu m_6555_(int a, Inventory inventory) {
        this.handler.setStackInSlot(0, (ItemStack)this.items.get(0));
        this.handler.setStackInSlot(1, (ItemStack)this.items.get(1));
        return new TransformerMenu(a, inventory, (Container)this, this.dataAccess);
    }
}

