/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.common.blocks;

import com.croparia.mod.common.blockEntity.CollectorBE;
import com.croparia.mod.core.init.BlockEntityInit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class Collector
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public Collector() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(10.0f).m_60977_());
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!worldIn.f_46443_ && (blockEntity = worldIn.m_7702_(pos)) instanceof CollectorBE && player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((CollectorBE)blockEntity), (BlockPos)pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState state2, boolean p_60519_) {
        BlockEntity blockEntity;
        if (!state.m_60713_(state2.m_60734_()) && (blockEntity = level.m_7702_(blockPos)) instanceof CollectorBE) {
            Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)((CollectorBE)blockEntity));
            level.m_46717_(blockPos, (Block)this);
        }
        super.m_6810_(state, level, blockPos, state2, p_60519_);
    }

    private boolean connectedToPower(Level worldIn, BlockPos pos, Direction facing) {
        for (Direction direction : Direction.values()) {
            if (direction == facing || !worldIn.m_46616_(pos.m_142300_(direction), direction)) continue;
            return true;
        }
        return false;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        boolean powerConnected = this.connectedToPower(worldIn, pos, (Direction)state.m_61143_((Property)FACING));
        AtomicBoolean energy = new AtomicBoolean(false);
        ((CollectorBE)worldIn.m_7702_(pos)).getCapability(CapabilityEnergy.ENERGY).ifPresent(cap -> {
            if (cap.getEnergyStored() > 0) {
                energy.set(true);
            }
        });
        if (!powered && powerConnected && energy.get()) {
            worldIn.m_46597_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        } else if (!(!powered || powerConnected && energy.get())) {
            worldIn.m_46597_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return side != Direction.NORTH;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityInit.COLLECTOR_BE.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return Collector.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityInit.COLLECTOR_BE.get()), CollectorBE::tick);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }
}

