/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.common.items;

import com.croparia.mod.CropariaMod;
import com.croparia.mod.core.init.ItemInit;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class Multitool
extends DiggerItem {
    protected static final Map<Block, BlockState> HOE_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.f_50440_, (Object)Blocks.f_50093_.m_49966_(), (Object)Blocks.f_152481_, (Object)Blocks.f_50093_.m_49966_(), (Object)Blocks.f_50493_, (Object)Blocks.f_50093_.m_49966_(), (Object)Blocks.f_50546_, (Object)Blocks.f_50493_.m_49966_()));

    public Multitool(float attackDamageIn, float attackSpeedIn, Tier tier) {
        super(attackDamageIn, attackSpeedIn, tier, (Tag)BlockTags.f_144282_, new Item.Properties().m_41491_(CropariaMod.MAIN));
    }

    public boolean m_6777_(BlockState p_41441_, Level p_41442_, BlockPos p_41443_, Player p_41444_) {
        return super.m_6777_(p_41441_, p_41442_, p_41443_, p_41444_);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state != Blocks.f_50016_.m_49966_() && state != Blocks.f_50375_.m_49966_() && state != Blocks.f_50752_.m_49966_();
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (this.isCorrectToolForDrops(stack, state)) {
            return this.f_40980_;
        }
        return 1.0f;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        if (toRepair.m_41720_() == ItemInit.WOOD_MULTITOOL.get() && repair.m_41720_() == Items.f_42647_) {
            return true;
        }
        if (toRepair.m_41720_() == ItemInit.STONE_MULTITOOL.get() && repair.m_41720_() == Items.f_42594_) {
            return true;
        }
        if (toRepair.m_41720_() == ItemInit.IRON_MULTITOOL.get() && repair.m_41720_() == Items.f_42416_) {
            return true;
        }
        if (toRepair.m_41720_() == ItemInit.GOLD_MULTITOOL.get() && repair.m_41720_() == Items.f_42417_) {
            return true;
        }
        if (toRepair.m_41720_() == ItemInit.DIAMOND_MULTITOOL.get() && repair.m_41720_() == Items.f_42415_) {
            return true;
        }
        if (toRepair.m_41720_() == ItemInit.OBSIDIAN_MULTITOOL.get() && repair.m_41720_() == Items.f_41999_) {
            return true;
        }
        if (toRepair.m_41720_() == ItemInit.RENFORCED_MULTITOOL.get() && repair.m_41720_() == Items.f_42415_) {
            return true;
        }
        return toRepair.m_41720_() == ItemInit.NETHERITE_MULTITOOL.get() && repair.m_41720_() == Items.f_42418_;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState blockstate;
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        int hook = ForgeEventFactory.onHoeUse((UseOnContext)context);
        if (hook != 0) {
            return hook > 0 ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        if (context.m_43719_() != Direction.DOWN && world.m_46859_(blockpos.m_7494_()) && (blockstate = HOE_LOOKUP.get(world.m_8055_(blockpos).m_60734_())) != null) {
            Player playerentity = context.m_43723_();
            world.m_5594_(playerentity, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_) {
                world.m_7731_(blockpos, blockstate, 11);
                if (playerentity != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)playerentity, player -> player.m_21190_(context.m_43724_()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, player -> player.m_21190_(attacker.m_7655_()));
        return true;
    }
}

