/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.core.recipes;

import com.croparia.mod.core.recipes.IRitualRecipe;
import com.croparia.mod.core.recipes.RecipeTypes;
import com.croparia.mod.core.recipes.rituals.FirstRitual;
import com.croparia.mod.core.recipes.rituals.RitualUtils;
import com.croparia.mod.core.recipes.rituals.SecondRitual;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RitualRecipe
implements IRitualRecipe {
    public static List<RitualRecipe> recipes = new ArrayList<RitualRecipe>();
    private final Item base;
    private final BlockState blockNeed;
    private final ItemStack result;
    private final int ritualTier;
    private final ResourceLocation id;

    public RitualRecipe(ResourceLocation id, Item base, BlockState blockNeed, ItemStack result, int ritualTier) {
        this.base = base;
        this.blockNeed = blockNeed;
        this.result = result;
        this.ritualTier = ritualTier;
        this.id = id;
    }

    public static void craft(ItemStack input, Level world, BlockPos pos) {
        boolean ret = false;
        int index = 0;
        while (!ret && index < recipes.size()) {
            if (RitualRecipe.recipes.get((int)index).base == input.m_41720_()) {
                switch (RitualRecipe.recipes.get((int)index).ritualTier) {
                    case 1: {
                        if (!FirstRitual.checkRitual(RitualRecipe.recipes.get((int)index).blockNeed, world, pos, false)) break;
                        ret = true;
                        break;
                    }
                    case 2: {
                        if (!SecondRitual.checkRitual(RitualRecipe.recipes.get((int)index).blockNeed, world, pos, false)) break;
                        ret = true;
                    }
                }
            }
            if (ret) continue;
            ++index;
        }
        if (ret) {
            RitualUtils.endFirst(RitualRecipe.recipes.get((int)index).result, input, pos, world);
        }
    }

    public static void addRecipe(String id, Item input, BlockState blockNeed, Item output, int ritualTier) {
        recipes.add(new RitualRecipe(new ResourceLocation("croparia" + id), input, blockNeed, new ItemStack((ItemLike)output), ritualTier));
    }

    public static void addRecipe(String id, Item input, BlockState blockNeed, ItemStack output, int ritualTier) {
        recipes.add(new RitualRecipe(new ResourceLocation("croparia" + id), input, blockNeed, output, ritualTier));
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ItemStack getBlockNeed() {
        return new ItemStack((ItemLike)this.blockNeed.m_60734_());
    }

    public int getRitualTier() {
        return this.ritualTier;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.base}));
        return list;
    }

    public boolean m_5818_(Container p_44002_, Level p_44003_) {
        return true;
    }

    public ItemStack m_5874_(Container p_44001_) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return null;
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.RITUAL;
    }
}

