/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.core.recipes;

import com.croparia.mod.CropariaMod;
import com.croparia.mod.core.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapelessTagRecipe
extends ShapelessRecipe {
    public ShapelessTagRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> inputs) {
        super(id, group, output, inputs);
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.SHAPELESS_TAG;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapelessTagRecipe> {
        public ShapelessTagRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122779_();
            for (int i = 0; i < array.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)array.get(i));
                if (ingredient.m_43947_()) continue;
                inputs.add((Object)ingredient);
            }
            if (inputs.isEmpty()) {
                throw new JsonParseException("No ingredients");
            }
            if (inputs.size() > 9) {
                throw new JsonParseException("Max ingredients' count is 9");
            }
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            String tag = GsonHelper.m_13906_((JsonObject)result, (String)"tag");
            int count = GsonHelper.m_13824_((JsonObject)result, (String)"count", (int)1);
            Item item = null;
            try {
                item = CropariaMod.getItemFromTag(tag);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            if (item == Items.f_41852_) {
                System.out.print("no item with the tag :" + tag);
                return null;
            }
            ItemStack output = new ItemStack((ItemLike)item, count);
            return new ShapelessTagRecipe(recipeId, group, output, (NonNullList<Ingredient>)inputs);
        }

        public ShapelessTagRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int j = 0; j < inputs.size(); ++j) {
                inputs.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new ShapelessTagRecipe(recipeId, group, output, (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessTagRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
        }
    }
}

