/*
 * Decompiled with CFR 0.152.
 */
package com.crypticcosmos.crypticcosmos.block;

import com.crypticcosmos.crypticcosmos.register.BlockRegistries;
import com.crypticcosmos.crypticcosmos.register.CrypticCosmosDimensions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.TickEvent;

public class RiftBlock
extends Block {
    public RiftBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public static void riftSpawning(@Nonnull TickEvent.PlayerTickEvent event) {
        int spawningChance = 15000;
        int minDistance = 5;
        int maxDistance = 120;
        PlayerEntity player = event.player;
        World world = player.func_130014_f_();
        if (ThreadLocalRandom.current().nextInt(15000) == 0 && !World.field_234920_i_.equals(world.func_234923_W_()) && !World.field_234919_h_.equals(world.func_234923_W_())) {
            for (Direction direction : Direction.values()) {
                for (int i = 0; i <= 120; ++i) {
                    BlockPos riftPos;
                    BlockState riftState;
                    if (i < 5 || !(riftState = world.func_180495_p(riftPos = player.func_233580_cy_().func_177967_a(direction, i))).func_196958_f() || riftPos.equals((Object)player.func_233580_cy_())) continue;
                    if (world.func_180495_p(riftPos.func_177972_a(direction)).func_177230_c().equals(BlockRegistries.RIFT_BLOCK.get())) {
                        return;
                    }
                    world.func_175656_a(riftPos, ((RiftBlock)((Object)BlockRegistries.RIFT_BLOCK.get())).func_176223_P());
                    return;
                }
            }
        }
    }

    private static RegistryKey<World> getDestination(World world) {
        ArrayList VALID_DIMENSIONS = Lists.newArrayList((Object[])new RegistryKey[]{World.field_234918_g_, CrypticCosmosDimensions.MAKROSSA_KEY, CrypticCosmosDimensions.UMBRAL_DAWN_KEY});
        VALID_DIMENSIONS.remove(world.func_234923_W_());
        return (RegistryKey)VALID_DIMENSIONS.get(ThreadLocalRandom.current().nextInt(VALID_DIMENSIONS.size()));
    }

    public static RegistryKey<World> rift(World world, Entity entity, final BlockPos pos) {
        RegistryKey<World> dimension = RiftBlock.getDestination(entity.func_130014_f_());
        ServerWorld destination = world.func_73046_m().func_71218_a(dimension);
        entity.changeDimension(destination, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                Entity repositionedEntity = repositionEntity.apply(false);
                repositionedEntity.func_242279_ag();
                int x = pos.func_177958_n();
                int z = pos.func_177952_p();
                int surfaceY = destWorld.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z);
                int y = surfaceY < 1 ? 70 : surfaceY;
                repositionedEntity.func_225653_b_((double)x, (double)y, (double)z);
                currentWorld.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                return repositionedEntity;
            }
        });
        return dimension;
    }

    public void func_196262_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (!entity.func_70089_S() || entity.func_130014_f_().func_201670_d()) {
            return;
        }
        if (entity.func_184218_aH() || entity.func_184207_aI() || !entity.func_184222_aU()) {
            return;
        }
        RiftBlock.rift(worldIn, entity, pos);
    }
}

