/*
 * Decompiled with CFR 0.152.
 */
package com.crypticcosmos.crypticcosmos.util;

import com.crypticcosmos.crypticcosmos.CrypticCosmos;
import com.crypticcosmos.crypticcosmos.block.Infectable;
import com.crypticcosmos.crypticcosmos.block.MondroveLog;
import com.crypticcosmos.crypticcosmos.block.OvergrownLunonBlock;
import com.crypticcosmos.crypticcosmos.register.LunonRegistries;
import com.crypticcosmos.crypticcosmos.register.MondroveRegistries;
import com.crypticcosmos.crypticcosmos.repack.registrate.providers.DataGenContext;
import com.crypticcosmos.crypticcosmos.repack.registrate.providers.RegistrateBlockstateProvider;
import com.crypticcosmos.crypticcosmos.repack.registrate.util.nullness.NonNullSupplier;
import java.util.function.Supplier;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class RegistrationUtils {
    public static ConfiguredModel[] infectableBlockModels(BlockState state, DataGenContext<Block, ? extends Infectable> context, RegistrateBlockstateProvider provider) {
        String infectionLevel = (Integer)state.func_177229_b((Property)Infectable.INFECTION_LEVEL) == 0 ? "" : ((Integer)state.func_177229_b((Property)Infectable.INFECTION_LEVEL)).toString();
        String name = context.getId().func_110623_a() + infectionLevel;
        return ConfiguredModel.builder().modelFile((ModelFile)provider.models().cubeAll(name, RegistrationUtils.blockTexture(context, infectionLevel))).build();
    }

    public static ConfiguredModel[] mondroveLogModels(BlockState state, DataGenContext<Block, MondroveLog> context, RegistrateBlockstateProvider provider, boolean isStripped) {
        String infectionLevel = (Integer)state.func_177229_b((Property)Infectable.INFECTION_LEVEL) == 0 ? "" : ((Integer)state.func_177229_b((Property)Infectable.INFECTION_LEVEL)).toString();
        Direction.Axis axis = RegistrationUtils.getAxisFromBlockState(state);
        String name = context.getId().func_110623_a() + infectionLevel;
        return ConfiguredModel.builder().modelFile((ModelFile)provider.models().cubeColumn(name, RegistrationUtils.blockTexture(isStripped ? "stripped_" : "", (Block)MondroveRegistries.MONDROVE_LOG.get(), !isStripped ? infectionLevel : ""), RegistrationUtils.blockTexture(isStripped ? "stripped_" : "", (Block)MondroveRegistries.MONDROVE_LOG.get(), "_top"))).rotationX(axis.equals((Object)Direction.Axis.Z) || axis.equals((Object)Direction.Axis.X) ? 90 : 0).rotationY(axis.equals((Object)Direction.Axis.X) ? 90 : 0).build();
    }

    public static ConfiguredModel[] mondroveWoodModels(BlockState state, DataGenContext<Block, MondroveLog> context, RegistrateBlockstateProvider provider, boolean isStripped) {
        Direction.Axis axis = RegistrationUtils.getAxisFromBlockState(state);
        String infectionLevel = (Integer)state.func_177229_b((Property)Infectable.INFECTION_LEVEL) == 0 ? "" : ((Integer)state.func_177229_b((Property)Infectable.INFECTION_LEVEL)).toString();
        String name = context.getId().func_110623_a() + infectionLevel;
        return ConfiguredModel.builder().modelFile((ModelFile)provider.models().cubeAll(name, RegistrationUtils.blockTexture(isStripped ? "stripped_" : "", (Block)MondroveRegistries.MONDROVE_LOG.get(), !isStripped ? infectionLevel : ""))).rotationX(axis.equals((Object)Direction.Axis.Z) || axis.equals((Object)Direction.Axis.X) ? 90 : 0).rotationY(axis.equals((Object)Direction.Axis.X) ? 90 : 0).build();
    }

    public static void overgrownLunonModels(DataGenContext<Block, OvergrownLunonBlock> context, RegistrateBlockstateProvider provider) {
        provider.getVariantBuilder((Block)context.get()).forAllStates(blockState -> {
            boolean isSnowy = (Boolean)blockState.func_177229_b((Property)OvergrownLunonBlock.field_196382_a);
            Direction axis = (Direction)blockState.func_177229_b((Property)OvergrownLunonBlock.FACING);
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            String id = context.getId().func_110623_a();
            int degree = (int)axis.func_185119_l();
            if (!isSnowy) {
                builder.modelFile((ModelFile)provider.models().cubeBottomTop(id, RegistrationUtils.blockTexture(context, "_side"), provider.blockTexture((Block)LunonRegistries.LUNON.get()), RegistrationUtils.blockTexture(context, "_top"))).rotationY(degree);
            } else {
                builder.modelFile((ModelFile)provider.models().cubeBottomTop(id, RegistrationUtils.blockTexture(LunonRegistries.OVERGROWN_LUNON, "_snow"), provider.blockTexture((Block)LunonRegistries.LUNON.get()), RegistrationUtils.blockTexture(context, "_top")));
            }
            return builder.build();
        });
    }

    public static void leavesModel(DataGenContext<Block, LeavesBlock> context, RegistrateBlockstateProvider provider) {
        provider.getVariantBuilder((Block)context.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)provider.models().withExistingParent(context.getId().func_110623_a(), provider.mcLoc("leaves"))).texture("all", provider.blockTexture((Block)context.get()))).build());
    }

    public static void crossModel(DataGenContext<Block, ? extends Block> context, RegistrateBlockstateProvider provider) {
        String name = context.getId().func_110623_a();
        provider.getVariantBuilder(context.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)provider.models().cross(name, provider.blockTexture((Block)context.get()))).build());
    }

    public static void doorModel(DataGenContext<Block, ? extends DoorBlock> context, RegistrateBlockstateProvider provider) {
        provider.doorBlock(context.get(), RegistrationUtils.blockTexture(context, "_bottom"), RegistrationUtils.blockTexture(context, "_top"));
    }

    public static void buttonModel(DataGenContext<Block, ? extends AbstractButtonBlock> context, RegistrateBlockstateProvider provider, NonNullSupplier<? extends Block> planks) {
        String id = context.getId().func_110623_a();
        ConfiguredModel.Builder buttonModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)provider.models().withExistingParent(id, "button")).texture("texture", provider.blockTexture(planks.get())));
        ConfiguredModel.Builder buttonPressedModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)provider.models().withExistingParent(id + "_pressed", "button_pressed")).texture("texture", provider.blockTexture(planks.get())));
        ConfiguredModel.Builder buttonInventoryModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)provider.models().withExistingParent(id + "_inventory", "button_inventory")).texture("texture", provider.blockTexture(planks.get())));
        provider.getVariantBuilder((Block)context.get()).forAllStates(state -> {
            AttachFace attachedFace = (AttachFace)state.func_177229_b((Property)AbstractButtonBlock.field_196366_M);
            Direction direction = (Direction)state.func_177229_b((Property)AbstractButtonBlock.field_185512_D);
            boolean isPowered = (Boolean)state.func_177229_b((Property)AbstractButtonBlock.field_176584_b);
            int rotationY = 0;
            if (direction.equals((Object)Direction.EAST)) {
                rotationY = 90;
            }
            if (direction.equals((Object)Direction.SOUTH)) {
                rotationY = 180;
            }
            if (direction.equals((Object)Direction.WEST)) {
                rotationY = 270;
            }
            int rotationX = 0;
            if (attachedFace.equals((Object)AttachFace.CEILING)) {
                rotationX = 180;
            } else if (attachedFace.equals((Object)AttachFace.WALL)) {
                rotationX = 90;
            }
            if (!isPowered) {
                return buttonModel.rotationX(rotationX).rotationY(rotationY).build();
            }
            return buttonPressedModel.rotationX(rotationX).rotationY(rotationY).build();
        });
    }

    public static void pressurePlateModels(DataGenContext<Block, ? extends PressurePlateBlock> context, RegistrateBlockstateProvider provider, NonNullSupplier<? extends Block> planks) {
        String id = context.getId().func_110623_a();
        provider.getVariantBuilder((Block)context.get()).forAllStates(state -> {
            String parentSuffix = (Boolean)state.func_177229_b((Property)PressurePlateBlock.field_176580_a) != false ? "_down" : "_up";
            String idSuffix = (Boolean)state.func_177229_b((Property)PressurePlateBlock.field_176580_a) != false ? "_down" : "";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)provider.models().withExistingParent(id + idSuffix, "pressure_plate" + parentSuffix)).texture("texture", provider.blockTexture((Block)planks.get()))).build();
        });
    }

    public static Direction.Axis getAxisFromBlockState(BlockState state) {
        return (Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A);
    }

    public static ResourceLocation blockTexture(Supplier<? extends Block> block, String suffix) {
        return CrypticCosmos.id("block/" + block.get().getRegistryName().func_110623_a() + suffix);
    }

    public static ResourceLocation blockTexture(String prefix, Block block, String suffix) {
        return CrypticCosmos.id("block/" + prefix + block.getRegistryName().func_110623_a() + suffix);
    }
}

