/*
 * Decompiled with CFR 0.152.
 */
package com.crypticcosmos.crypticcosmos.world.biomes;

import net.minecraft.client.audio.BackgroundMusicTracks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;

public class BiomeHelper {
    public static final int DEFAULT_WATER_COLOR = 4159204;
    public static final int DEFAULT_WATER_FOG_COLOR = 329011;
    public static final int DEFAULT_GRASS_COLOR = 9551193;
    public static final int DEFAULT_FOLIAGE_COLOR = 7842607;
    public static final int DEFAULT_SKY_FOG_COLOR = 12638463;

    public static Biome biome(Biome.RainType precipitation, Biome.Category category, float depth, float scale, float temperature, float downfall, BiomeAmbience.Builder effects, BiomeGenerationSettings.Builder genSettings, MobSpawnInfo spawnSettings) {
        return new Biome.Builder().func_205415_a(precipitation).func_205419_a(category).func_205421_a(depth).func_205420_b(scale).func_205414_c(temperature).func_205417_d(downfall).func_235097_a_(effects.func_235238_a_()).func_242457_a(genSettings.func_242508_a()).func_242458_a(spawnSettings).func_242455_a();
    }

    public static <C extends ISurfaceBuilderConfig> BiomeGenerationSettings.Builder genSettings(SurfaceBuilder<C> surfaceBuilder, C config) {
        return new BiomeGenerationSettings.Builder().func_242517_a(surfaceBuilder.func_242929_a(config));
    }

    public static MobSpawnInfo.Builder spawnSettings() {
        return new MobSpawnInfo.Builder();
    }

    public static void addSpawn(MobSpawnInfo.Builder spawnSettings, EntityClassification classification, EntityType<?> entityType, int weight, int min, int max) {
        spawnSettings.func_242575_a(classification, new MobSpawnInfo.Spawners(entityType, weight, min, max));
    }

    public static BiomeAmbience.Builder effects(int waterColor, int waterFogColor, int grassColor, int foliageColor, float temperature, int skyFogColor, SoundEvent music) {
        return new BiomeAmbience.Builder().func_235246_b_(waterColor).func_235248_c_(waterFogColor).func_242541_f(grassColor).func_242540_e(foliageColor).func_242539_d(BiomeHelper.getSkyForTemp(temperature)).func_235239_a_(skyFogColor).func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)music));
    }

    public static int getSkyForTemp(float temperature) {
        float a = MathHelper.func_76131_a((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - a * 0.05f), (float)(0.5f + a * 0.1f), (float)1.0f);
    }
}

