/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic;

import com.lothrazar.cyclic.ConfigRegistry;
import com.lothrazar.cyclic.CyclicLogger;
import com.lothrazar.cyclic.compat.curios.CuriosRegistry;
import com.lothrazar.cyclic.event.ClientInputEvents;
import com.lothrazar.cyclic.event.EventRender;
import com.lothrazar.cyclic.event.ItemEvents;
import com.lothrazar.cyclic.event.PlayerAbilityEvents;
import com.lothrazar.cyclic.event.PlayerDataEvents;
import com.lothrazar.cyclic.event.PotionEvents;
import com.lothrazar.cyclic.event.WorldGenEvents;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ClientRegistry;
import com.lothrazar.cyclic.registry.CommandRegistry;
import com.lothrazar.cyclic.registry.FluidRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.registry.PotionRegistry;
import com.lothrazar.cyclic.registry.RecipeRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.registry.WorldGenRegistry;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;

@Mod(value="cyclic")
public class ModCyclic {
    public static final String MODID = "cyclic";
    public static final CyclicLogger LOGGER = new CyclicLogger(LogManager.getLogger());

    public ModCyclic() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        ConfigRegistry.setup(FMLPaths.CONFIGDIR.get().resolve("cyclic.toml"));
        FluidRegistry.setup();
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(IRecipeSerializer.class, RecipeRegistry::registerRecipeSerializers);
        MinecraftForge.EVENT_BUS.register((Object)new CommandRegistry());
        MinecraftForge.EVENT_BUS.register((Object)new EventRender());
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BlockRegistry.BLOCKS.register(bus);
        ItemRegistry.ITEMS.register(bus);
        TileRegistry.TILES.register(bus);
    }

    private void setupClient(FMLClientSetupEvent event) {
        ClientRegistry.setup();
    }

    private void setup(FMLCommonSetupEvent event) {
        CuriosRegistry.setup(event);
        PotionRegistry.setup(event);
        PacketRegistry.setup();
        WorldGenRegistry.setup();
        MinecraftForge.EVENT_BUS.register((Object)new ClientInputEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PotionEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ItemEvents());
        MinecraftForge.EVENT_BUS.register((Object)new WorldGenEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerDataEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerAbilityEvents());
    }
}

