/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.cable.CableWrench;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class CableBase
extends BlockBase {
    public static final EnumProperty<EnumConnectType> DOWN = EnumProperty.func_177709_a((String)"down", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> UP = EnumProperty.func_177709_a((String)"up", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> NORTH = EnumProperty.func_177709_a((String)"north", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> SOUTH = EnumProperty.func_177709_a((String)"south", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> WEST = EnumProperty.func_177709_a((String)"west", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> EAST = EnumProperty.func_177709_a((String)"east", EnumConnectType.class);
    public static final Map<Direction, EnumProperty<EnumConnectType>> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), p -> {
        p.put(Direction.NORTH, NORTH);
        p.put(Direction.EAST, EAST);
        p.put(Direction.SOUTH, SOUTH);
        p.put(Direction.WEST, WEST);
        p.put(Direction.UP, UP);
        p.put(Direction.DOWN, DOWN);
    });
    private static final double top = 16.0;
    private static final double bot = 0.0;
    private static final double C = 8.0;
    private static final double w = 2.0;
    private static final double sm = 6.0;
    private static final double lg = 10.0;
    protected static final VoxelShape AABB = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    protected static final VoxelShape AABB_UP = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape AABB_DOWN = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    protected static final VoxelShape AABB_NORTH = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0);
    protected static final VoxelShape AABB_SOUTH = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0);
    protected static final VoxelShape AABB_WEST = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    protected static final VoxelShape AABB_EAST = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);

    static boolean shapeConnects(BlockState state, EnumProperty<EnumConnectType> dirctionProperty) {
        return ((EnumConnectType)((Object)state.func_177229_b(dirctionProperty))).isConnected();
    }

    public static VoxelShape createShape(BlockState state) {
        VoxelShape shape = AABB;
        if (CableBase.shapeConnects(state, UP)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_UP, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (CableBase.shapeConnects(state, DOWN)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_DOWN, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (CableBase.shapeConnects(state, WEST)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_WEST, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (CableBase.shapeConnects(state, EAST)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_EAST, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (CableBase.shapeConnects(state, NORTH)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_NORTH, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (CableBase.shapeConnects(state, SOUTH)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_SOUTH, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }

    public CableBase(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (hit.func_216354_b() == null) {
            return super.func_225533_a_(state, world, pos, player, handIn, hit);
        }
        if (handIn != Hand.MAIN_HAND) {
            return super.func_225533_a_(state, world, pos, player, handIn, hit);
        }
        ItemStack stack = player.func_184586_b(handIn);
        if (!stack.func_77973_b().func_206844_a(CableWrench.WRENCH)) {
            boolean hasExtractor = false;
            for (Direction side : Direction.values()) {
                EnumConnectType connection = (EnumConnectType)((Object)state.func_177229_b((Property)FACING_TO_PROPERTY_MAP.get(side)));
                if (!connection.isExtraction()) continue;
                hasExtractor = true;
                break;
            }
            if (hasExtractor && (this == BlockRegistry.item_pipe || this == BlockRegistry.fluid_pipe)) {
                if (!world.field_72995_K) {
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof INamedContainerProvider) {
                        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
                    } else {
                        throw new IllegalStateException("Our named container provider is missing!");
                    }
                }
                return ActionResultType.SUCCESS;
            }
            return super.func_225533_a_(state, world, pos, player, handIn, hit);
        }
        float hitLimit = 0.28f;
        Direction sideToToggle = hit.func_216354_b();
        double hitX = hit.func_216347_e().field_72450_a - (double)pos.func_177958_n();
        double hitY = hit.func_216347_e().field_72448_b - (double)pos.func_177956_o();
        double hitZ = hit.func_216347_e().field_72449_c - (double)pos.func_177952_p();
        if (hitX < (double)0.28f) {
            sideToToggle = Direction.WEST;
        } else if (hitX > (double)0.72f) {
            sideToToggle = Direction.EAST;
        } else if (hitY < (double)0.28f) {
            sideToToggle = Direction.DOWN;
        } else if (hitY > (double)0.72f) {
            sideToToggle = Direction.UP;
        } else if (hitZ < (double)0.28f) {
            sideToToggle = Direction.NORTH;
        } else if (hitZ > (double)0.72f) {
            sideToToggle = Direction.SOUTH;
        }
        EnumProperty<EnumConnectType> prop = FACING_TO_PROPERTY_MAP.get(sideToToggle);
        if (state.func_235901_b_(prop)) {
            EnumConnectType status = (EnumConnectType)((Object)state.func_177229_b(prop));
            BlockState newState = state;
            boolean updatePost = false;
            switch (status) {
                case BLOCKED: {
                    newState = (BlockState)state.func_206870_a(prop, (Comparable)((Object)EnumConnectType.NONE));
                    updatePost = true;
                    break;
                }
                case INVENTORY: 
                case NONE: {
                    newState = (BlockState)state.func_206870_a(prop, (Comparable)((Object)EnumConnectType.CABLE));
                    break;
                }
                case CABLE: {
                    newState = (BlockState)state.func_206870_a(prop, (Comparable)((Object)EnumConnectType.BLOCKED));
                }
            }
            world.func_175656_a(pos, newState);
            if (updatePost) {
                newState.func_196956_a(sideToToggle, world.func_180495_p(pos.func_177972_a(sideToToggle)), (IWorld)world, pos, pos.func_177972_a(sideToToggle));
            }
        }
        return super.func_225533_a_(state, world, pos, player, handIn, hit);
    }

    public static boolean isCableBlocked(BlockState blockState, Direction side) {
        if (side == null) {
            return false;
        }
        EnumProperty<EnumConnectType> property = FACING_TO_PROPERTY_MAP.get(side);
        return blockState.func_177230_c() instanceof CableBase && blockState.func_235901_b_(property) && !((EnumConnectType)((Object)blockState.func_177229_b(property))).isUnBlocked();
    }
}

