/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.energy;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileCableEnergy
extends TileEntityBase
implements ITickableTileEntity {
    private static final int MAX = 32000;
    CustomEnergyStorage energy = new CustomEnergyStorage(32000, 32000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private Map<Direction, Integer> mapIncomingEnergy = Maps.newHashMap();
    private static final int TIMER_SIDE_INPUT = 15;

    public TileCableEnergy() {
        super(TileRegistry.energy_pipeTile);
        for (Direction f : Direction.values()) {
            this.mapIncomingEnergy.put(f, 0);
        }
    }

    public void func_73660_a() {
        this.syncEnergy();
        this.tickDownIncomingPowerFaces();
        this.tickCableFlow();
        for (Direction side : Direction.values()) {
            EnumConnectType connection = (EnumConnectType)((Object)this.func_195044_w().func_177229_b((Property)CableBase.FACING_TO_PROPERTY_MAP.get(side)));
            if (!connection.isExtraction()) continue;
            this.tryExtract(side);
        }
    }

    private void tryExtract(Direction extractSide) {
        int extractSim;
        IEnergyStorage itemHandlerFrom;
        if (extractSide == null) {
            return;
        }
        BlockPos posTarget = this.field_174879_c.func_177972_a(extractSide);
        TileEntity tile = this.field_145850_b.func_175625_s(posTarget);
        if (tile != null && (itemHandlerFrom = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, extractSide.func_176734_d()).orElse(null)) != null && (extractSim = itemHandlerFrom.extractEnergy(32000, true)) > 0 && this.energy.receiveEnergy(extractSim, true) > 0) {
            int n = itemHandlerFrom.extractEnergy(this.energy.receiveEnergy(extractSim, false), false);
        }
    }

    private void tickCableFlow() {
        List rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());
        Collections.shuffle(rawList);
        for (Integer i : rawList) {
            Direction outgoingSide = Direction.values()[i];
            EnumConnectType connection = (EnumConnectType)((Object)this.func_195044_w().func_177229_b((Property)CableBase.FACING_TO_PROPERTY_MAP.get(outgoingSide)));
            if (connection.isExtraction() || connection.isBlocked() || this.isEnergyIncomingFromFace(outgoingSide)) continue;
            this.moveEnergy(outgoingSide, 32000);
        }
    }

    public void tickDownIncomingPowerFaces() {
        for (Direction f : Direction.values()) {
            if (this.mapIncomingEnergy.get(f) <= 0) continue;
            this.mapIncomingEnergy.put(f, this.mapIncomingEnergy.get(f) - 1);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && !CableBase.isCableBlocked(this.func_195044_w(), side)) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            this.mapIncomingEnergy.put(f, tag.func_74762_e(f.func_176610_l() + "_incenergy"));
        }
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            tag.func_74768_a(f.func_176610_l() + "_incenergy", this.mapIncomingEnergy.get(f).intValue());
        }
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        return super.func_189515_b(tag);
    }

    private boolean isEnergyIncomingFromFace(Direction face) {
        return this.mapIncomingEnergy.get(face) > 0;
    }

    public void updateIncomingEnergyFace(Direction inputFrom) {
        this.mapIncomingEnergy.put(inputFrom, 15);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

