/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.fluid;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.fluid.ContainerCableFluid;
import com.lothrazar.cyclic.item.datacard.filter.FilterCardItem;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilFluid;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCableFluid
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    ItemStackHandler filter = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == ItemRegistry.filter_data;
        }
    };
    public static final int CAPACITY = 16000;
    public static final int FLOW_RATE = 16000;
    public static final int EXTRACT_RATE = 16000;
    public static final int TRANSFER_FLUID_PER_TICK = 500;
    private Map<Direction, LazyOptional<FluidTankBase>> flow = Maps.newHashMap();
    List<Integer> rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());

    public TileCableFluid() {
        super(TileRegistry.fluid_pipeTile);
        for (Direction f : Direction.values()) {
            this.flow.put(f, (LazyOptional<FluidTankBase>)LazyOptional.of(() -> new FluidTankBase(this, 16000, p -> true)));
        }
    }

    public void func_73660_a() {
        for (Direction side : Direction.values()) {
            EnumConnectType connection = (EnumConnectType)((Object)this.func_195044_w().func_177229_b((Property)CableBase.FACING_TO_PROPERTY_MAP.get(side)));
            if (!connection.isExtraction()) continue;
            this.tryExtract(side);
        }
        this.normalFlow();
    }

    private void tryExtract(Direction extractSide) {
        Direction incomingSide;
        if (extractSide == null) {
            return;
        }
        BlockPos target = this.field_174879_c.func_177972_a(extractSide);
        IFluidHandler stuff = UtilFluid.getTank(this.field_145850_b, target, incomingSide = extractSide.func_176734_d());
        if (stuff == null) {
            return;
        }
        if (!FilterCardItem.filterAllowsExtract(this.filter.getStackInSlot(0), stuff.getFluidInTank(0))) {
            return;
        }
        boolean success = UtilFluid.tryFillPositionFromTank(this.field_145850_b, this.field_174879_c, extractSide, stuff, 16000);
        FluidTankBase sideHandler = (FluidTankBase)((Object)this.flow.get(extractSide).orElse(null));
        if (!success && sideHandler != null && sideHandler.getSpace() >= 1000) {
            BlockState targetState = this.field_145850_b.func_180495_p(target);
            FluidState fluid = targetState.func_204520_s();
            if (fluid != null && !fluid.func_206888_e() && fluid.func_206889_d()) {
                if (this.field_145850_b.func_175656_a(target, Blocks.field_150350_a.func_176223_P())) {
                    sideHandler.fill(new FluidStack(fluid.func_206886_c(), 1000), IFluidHandler.FluidAction.EXECUTE);
                }
            } else if (targetState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && ((Boolean)targetState.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && this.field_145850_b.func_175656_a(target, targetState = (BlockState)targetState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)))) {
                sideHandler.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    private void normalFlow() {
        for (Direction incomingSide : Direction.values()) {
            IFluidHandler sideHandler = (IFluidHandler)this.flow.get(incomingSide).orElse(null);
            Collections.shuffle(this.rawList);
            for (Integer i : this.rawList) {
                EnumConnectType connection;
                Direction outgoingSide = Direction.values()[i];
                if (outgoingSide == incomingSide || (connection = (EnumConnectType)((Object)this.func_195044_w().func_177229_b((Property)CableBase.FACING_TO_PROPERTY_MAP.get(outgoingSide)))).isExtraction() || connection.isBlocked()) continue;
                this.moveFluids(outgoingSide, 16000, sideHandler);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (side != null && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && !CableBase.isCableBlocked(this.func_195044_w(), side)) {
            return this.flow.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.filter.deserializeNBT(tag.func_74775_l("filter"));
        for (Direction dir : Direction.values()) {
            FluidTankBase fluidh = (FluidTankBase)((Object)this.flow.get(dir).orElse(null));
            if (!tag.func_74764_b("fluid" + dir.toString())) continue;
            fluidh.readFromNBT(tag.func_74775_l("fluid" + dir.toString()));
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("filter", (INBT)this.filter.serializeNBT());
        for (Direction dir : Direction.values()) {
            FluidTankBase fluidh = (FluidTankBase)((Object)this.flow.get(dir).orElse(null));
            CompoundNBT fluidtag = new CompoundNBT();
            if (fluidh != null) {
                fluidh.writeToNBT(fluidtag);
            }
            tag.func_218657_a("fluid" + dir.toString(), (INBT)fluidtag);
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerCableFluid(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }
}

