/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.conveyor;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.cable.CableWrench;
import com.lothrazar.cyclic.block.conveyor.ConveyorSpeed;
import com.lothrazar.cyclic.block.conveyor.ConveyorType;
import com.lothrazar.cyclic.block.conveyor.TileConveyor;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockConveyor
extends BlockBase {
    private static final int MAX_CONNECTED_UPDATE = 16;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape AG00 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.8, (double)16.0);
    protected static final VoxelShape AG01 = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape AG02 = Block.func_208617_a((double)2.0, (double)1.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape AG03 = Block.func_208617_a((double)3.0, (double)2.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape AG04 = Block.func_208617_a((double)4.0, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape AG05 = Block.func_208617_a((double)5.0, (double)4.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    protected static final VoxelShape AG06 = Block.func_208617_a((double)6.0, (double)5.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    protected static final VoxelShape AG07 = Block.func_208617_a((double)7.0, (double)6.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape AG08 = Block.func_208617_a((double)8.0, (double)7.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape AG09 = Block.func_208617_a((double)9.0, (double)8.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape AG10 = Block.func_208617_a((double)10.0, (double)9.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    protected static final VoxelShape AG11 = Block.func_208617_a((double)11.0, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape AG12 = Block.func_208617_a((double)12.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape AG13 = Block.func_208617_a((double)13.0, (double)12.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final VoxelShape AG14 = Block.func_208617_a((double)14.0, (double)13.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape AG15 = Block.func_208617_a((double)15.0, (double)14.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape AG16 = Block.func_208617_a((double)15.5, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape ANGLEEAST = VoxelShapes.func_216384_a((VoxelShape)AG00, (VoxelShape[])new VoxelShape[]{AG01, AG02, AG03, AG04, AG05, AG06, AG07, AG08, AG09, AG10, AG11, AG12, AG13, AG14, AG15, AG16});
    protected static final VoxelShape ANGLESOUTH = VoxelShapes.func_216384_a((VoxelShape)BlockConveyor.rot(AG00), (VoxelShape[])new VoxelShape[]{BlockConveyor.rot(AG01), BlockConveyor.rot(AG02), BlockConveyor.rot(AG03), BlockConveyor.rot(AG04), BlockConveyor.rot(AG05), BlockConveyor.rot(AG06), BlockConveyor.rot(AG07), BlockConveyor.rot(AG08), BlockConveyor.rot(AG09), BlockConveyor.rot(AG10), BlockConveyor.rot(AG11), BlockConveyor.rot(AG12), BlockConveyor.rot(AG13), BlockConveyor.rot(AG14), BlockConveyor.rot(AG15), BlockConveyor.rot(AG16)});
    protected static final VoxelShape ANGLENORTH = VoxelShapes.func_216384_a((VoxelShape)BlockConveyor.flipx(AG00), (VoxelShape[])new VoxelShape[]{BlockConveyor.flipx(AG01), BlockConveyor.flipx(AG02), BlockConveyor.flipx(AG03), BlockConveyor.flipx(AG04), BlockConveyor.flipx(AG05), BlockConveyor.flipx(AG06), BlockConveyor.flipx(AG07), BlockConveyor.flipx(AG08), BlockConveyor.flipx(AG09), BlockConveyor.flipx(AG10), BlockConveyor.flipx(AG11), BlockConveyor.flipx(AG12), BlockConveyor.flipx(AG13), BlockConveyor.flipx(AG14), BlockConveyor.flipx(AG15), BlockConveyor.flipx(AG16)});
    protected static final VoxelShape ANGLEWEST = VoxelShapes.func_216384_a((VoxelShape)BlockConveyor.flipz(AG00), (VoxelShape[])new VoxelShape[]{BlockConveyor.flipz(AG01), BlockConveyor.flipz(AG02), BlockConveyor.flipz(AG03), BlockConveyor.flipz(AG04), BlockConveyor.flipz(AG05), BlockConveyor.flipz(AG06), BlockConveyor.flipz(AG07), BlockConveyor.flipz(AG08), BlockConveyor.flipz(AG09), BlockConveyor.flipz(AG10), BlockConveyor.flipz(AG11), BlockConveyor.flipz(AG12), BlockConveyor.flipz(AG13), BlockConveyor.flipz(AG14), BlockConveyor.flipz(AG15), BlockConveyor.flipz(AG16)});
    public static final EnumProperty<DyeColor> COLOUR = EnumProperty.func_177709_a((String)"colour", DyeColor.class);
    public static final EnumProperty<ConveyorType> TYPE = EnumProperty.func_177709_a((String)"type", ConveyorType.class);
    public static final EnumProperty<ConveyorSpeed> SPEED = EnumProperty.func_177709_a((String)"speed", ConveyorSpeed.class);
    public static final List<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> STATE_PAIRS = BlockConveyor.generateStatePairs();

    public BlockConveyor(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(0.6f).func_226896_b_());
    }

    public static VoxelShape rot(VoxelShape shape) {
        double x1 = shape.func_197762_b(Direction.Axis.X);
        double x2 = shape.func_197758_c(Direction.Axis.X);
        double y1 = shape.func_197762_b(Direction.Axis.Y);
        double y2 = shape.func_197758_c(Direction.Axis.Y);
        double z1 = shape.func_197762_b(Direction.Axis.Z);
        double z2 = shape.func_197758_c(Direction.Axis.Z);
        double temp = z1;
        z1 = x1;
        x1 = temp;
        temp = z2;
        z2 = x2;
        x2 = temp;
        x1 = 1.0 - x1;
        x2 = 1.0 - x2;
        return VoxelShapes.func_197873_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static VoxelShape flipx(VoxelShape shape) {
        double x1 = shape.func_197762_b(Direction.Axis.X);
        double x2 = shape.func_197758_c(Direction.Axis.X);
        double y1 = shape.func_197762_b(Direction.Axis.Y);
        double y2 = shape.func_197758_c(Direction.Axis.Y);
        double z1 = shape.func_197762_b(Direction.Axis.Z);
        double z2 = shape.func_197758_c(Direction.Axis.Z);
        double temp = z1;
        z1 = x1;
        x1 = temp;
        temp = z2;
        z2 = x2;
        x2 = temp;
        z1 = 1.0 - z1;
        z2 = 1.0 - z2;
        return VoxelShapes.func_197873_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static VoxelShape flipz(VoxelShape shape) {
        double x1 = shape.func_197762_b(Direction.Axis.X);
        double x2 = shape.func_197758_c(Direction.Axis.X);
        double y1 = shape.func_197762_b(Direction.Axis.Y);
        double y2 = shape.func_197758_c(Direction.Axis.Y);
        double z1 = shape.func_197762_b(Direction.Axis.Z);
        double z2 = shape.func_197758_c(Direction.Axis.Z);
        x1 = 1.0 - x1;
        x2 = 1.0 - x2;
        z1 = 1.0 - z1;
        z2 = 1.0 - z2;
        return VoxelShapes.func_197873_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        if (state.func_177229_b(TYPE) == ConveyorType.UP) {
            switch (facing) {
                case EAST: {
                    return ANGLEEAST;
                }
                case NORTH: {
                    return ANGLENORTH;
                }
                case SOUTH: {
                    return ANGLESOUTH;
                }
                case WEST: {
                    return ANGLEWEST;
                }
            }
            if (state.func_177229_b(TYPE) == ConveyorType.DOWN) {
                switch (facing) {
                    case EAST: {
                        return ANGLEWEST;
                    }
                    case NORTH: {
                        return ANGLESOUTH;
                    }
                    case SOUTH: {
                        return ANGLENORTH;
                    }
                    case WEST: {
                        return ANGLEEAST;
                    }
                }
            }
        }
        return SHAPE;
    }

    public boolean func_220074_n(BlockState state) {
        return ((ConveyorType)((Object)state.func_177229_b(TYPE))).isVertical();
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return ((ConveyorType)((Object)state.func_177229_b(TYPE))).isVertical();
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> nextState;
        boolean success;
        Item heldItem = player.func_184586_b(hand).func_77973_b();
        if (heldItem instanceof DyeItem) {
            DyeItem dye = (DyeItem)heldItem;
            DyeColor newc = dye.func_195962_g();
            world.func_175656_a(pos, (BlockState)state.func_206870_a(COLOUR, (Comparable)newc));
            this.setConnectedColour(world, pos, newc, 0);
            return ActionResultType.SUCCESS;
        }
        if (heldItem == Items.field_221764_cr) {
            ConveyorSpeed speed = (ConveyorSpeed)((Object)state.func_177229_b(SPEED));
            if (world.func_175656_a(pos, (BlockState)state.func_206870_a(SPEED, (Comparable)((Object)speed.getNext())))) {
                this.setConnectedSpeed(world, pos, speed.getNext(), 0);
                return ActionResultType.SUCCESS;
            }
        } else if (heldItem.func_206844_a(CableWrench.WRENCH) && (success = world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)(nextState = BlockConveyor.nextConnectedState((ConveyorType)((Object)state.func_177229_b(TYPE)), (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J))).getKey()))).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)nextState.getValue())))) {
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    private BlockState getClosestConnected(World world, BlockPos pos) {
        for (Direction d : Direction.values()) {
            BlockPos offset = pos.func_177972_a(d);
            BlockState here = world.func_180495_p(offset);
            if (here.func_177230_c() != this) continue;
            return here;
        }
        return null;
    }

    private void setConnectedColour(World world, BlockPos pos, DyeColor speedIn, int maxRecursive) {
        if (maxRecursive > 16) {
            return;
        }
        for (Direction d : Direction.values()) {
            BlockPos offset = pos.func_177972_a(d);
            BlockState here = world.func_180495_p(offset);
            if (here.func_177230_c() != this) continue;
            world.func_175656_a(offset, (BlockState)here.func_206870_a(COLOUR, (Comparable)speedIn));
            this.setConnectedColour(world, offset, speedIn, ++maxRecursive);
        }
    }

    private void setConnectedSpeed(World world, BlockPos pos, ConveyorSpeed speedIn, int maxRecursive) {
        if (maxRecursive > 16) {
            return;
        }
        for (Direction d : Direction.values()) {
            BlockPos offset = pos.func_177972_a(d);
            BlockState here = world.func_180495_p(offset);
            if (here.func_177230_c() != this || !world.func_175656_a(offset, (BlockState)here.func_206870_a(SPEED, (Comparable)((Object)speedIn)))) continue;
            this.setConnectedSpeed(world, offset, speedIn, ++maxRecursive);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileConveyor();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        ConveyorSpeed speed = ConveyorSpeed.MEDIUM;
        ConveyorType type = ConveyorType.STRAIGHT;
        DyeColor col = DyeColor.GRAY;
        BlockState nearby = this.getClosestConnected(world, pos);
        if (nearby != null) {
            speed = (ConveyorSpeed)((Object)nearby.func_177229_b(SPEED));
            col = (DyeColor)nearby.func_177229_b(COLOUR);
        }
        Direction facing = placer != null ? placer.func_174811_aO() : Direction.NORTH;
        world.func_180501_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)facing)).func_206870_a(SPEED, (Comparable)((Object)speed))).func_206870_a(TYPE, (Comparable)((Object)type))).func_206870_a(COLOUR, (Comparable)col), 2);
        super.func_180633_a(world, pos, state, placer, stack);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J}).func_206894_a(new Property[]{SPEED}).func_206894_a(new Property[]{TYPE}).func_206894_a(new Property[]{COLOUR});
    }

    public static AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> nextState(ConveyorType t, Direction d) {
        AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> pair = new AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>(t, d);
        if (STATE_PAIRS.contains(pair)) {
            int index = STATE_PAIRS.indexOf(pair) + 1;
            return BlockConveyor.nextState(STATE_PAIRS, index);
        }
        return pair;
    }

    public static AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> nextConnectedState(ConveyorType t, Direction d) {
        AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> pair2;
        List<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> connectedStates = STATE_PAIRS.stream().filter(pair -> pair.getValue() == d).collect(Collectors.toList());
        if (connectedStates.contains(pair2 = new AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>(t, d))) {
            int index = connectedStates.indexOf(pair2) + 1;
            return BlockConveyor.nextState(connectedStates, index);
        }
        return pair2;
    }

    private static AbstractMap.SimpleImmutableEntry<ConveyorType, Direction> nextState(List<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> list, int index) {
        return list.get(BlockConveyor.nextIndex(list, index));
    }

    private static int nextIndex(List<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> list, int index) {
        return index >= list.size() ? index % list.size() : index;
    }

    public static List<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> generateStatePairs() {
        LinkedList<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>> pairs = new LinkedList<AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>>();
        for (ConveyorType t : ConveyorType.values()) {
            for (Direction d : BlockStateProperties.field_208157_J.func_177700_c()) {
                pairs.add(new AbstractMap.SimpleImmutableEntry<ConveyorType, Direction>(t, d));
            }
        }
        return pairs;
    }
}

