/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.detectorentity;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.detectorentity.CompareType;
import com.lothrazar.cyclic.block.detectorentity.ContainerDetector;
import com.lothrazar.cyclic.data.EntityFilterType;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileDetector
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int PER_TICK = 10;
    public static final int MAX_RANGE = 32;
    private int rangeX = 5;
    private int rangeY = 1;
    private int rangeZ = 5;
    private int limitUntilRedstone = 0;
    private CompareType compType = CompareType.GREATER;
    EntityFilterType entityFilter = EntityFilterType.LIVING;
    private boolean isPoweredNow = false;

    public TileDetector() {
        super(TileRegistry.detector_entity);
    }

    public void func_73660_a() {
        --this.timer;
        if (this.field_145850_b.field_72995_K || this.timer > 0) {
            return;
        }
        this.timer = 10;
        int entitiesFound = this.getCountInRange();
        boolean trigger = false;
        switch (this.compType) {
            case LESS: {
                trigger = entitiesFound < this.limitUntilRedstone;
                break;
            }
            case GREATER: {
                trigger = entitiesFound > this.limitUntilRedstone;
                break;
            }
            case EQUAL: {
                trigger = entitiesFound == this.limitUntilRedstone;
                break;
            }
        }
        if (this.isPoweredNow != trigger) {
            this.isPoweredNow = trigger;
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
            try {
                this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
            }
            catch (Throwable e) {
                ModCyclic.LOGGER.error("State change error in adjacent block ", e);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerDetector(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    @Override
    public boolean isPowered() {
        return this.isPoweredNow;
    }

    public List<BlockPos> getShape() {
        return UtilShape.getShape(this.getRange(), this.field_174879_c.func_177956_o());
    }

    private int getCountInRange() {
        List<? extends LivingEntity> list = this.entityFilter.getEntities(this.field_145850_b, this.getRange());
        return list.size();
    }

    private AxisAlignedBB getRange() {
        double x = this.field_174879_c.func_177958_n();
        double y = this.field_174879_c.func_177956_o();
        double z = this.field_174879_c.func_177952_p();
        AxisAlignedBB entityRange = new AxisAlignedBB(x - (double)this.rangeX, y - (double)this.rangeY, z - (double)this.rangeZ, x + (double)this.rangeX + 1.0, y + (double)this.rangeY, z + (double)this.rangeZ + 1.0);
        return entityRange;
    }

    @Override
    public int getField(int f) {
        switch (Fields.values()[f]) {
            case ENTITYTYPE: {
                return this.entityFilter.ordinal();
            }
            case GREATERTHAN: {
                return this.compType.ordinal();
            }
            case LIMIT: {
                return this.limitUntilRedstone;
            }
            case RANGEX: {
                return this.rangeX;
            }
            case RANGEY: {
                return this.rangeY;
            }
            case RANGEZ: {
                return this.rangeZ;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case GREATERTHAN: {
                if (value >= CompareType.values().length) {
                    value = 0;
                }
                if (value < 0) {
                    value = CompareType.values().length - 1;
                }
                this.compType = CompareType.values()[value];
                break;
            }
            case LIMIT: {
                if (value > 999) {
                    value = 999;
                }
                if (value < 0) {
                    value = 0;
                }
                this.limitUntilRedstone = value;
                break;
            }
            case RANGEX: {
                this.rangeX = value;
                break;
            }
            case RANGEY: {
                this.rangeY = value;
                break;
            }
            case RANGEZ: {
                this.rangeZ = value;
                break;
            }
            case ENTITYTYPE: {
                if (value >= EntityFilterType.values().length) {
                    value = 0;
                }
                if (value < 0) {
                    value = EntityFilterType.values().length - 1;
                }
                this.entityFilter = EntityFilterType.values()[value];
            }
        }
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        int eType;
        this.rangeX = tag.func_74762_e("ox");
        this.rangeY = tag.func_74762_e("oy");
        this.rangeZ = tag.func_74762_e("oz");
        this.limitUntilRedstone = tag.func_74762_e("limit");
        int cType = tag.func_74762_e("compare");
        if (cType >= 0 && cType < CompareType.values().length) {
            this.compType = CompareType.values()[cType];
        }
        if ((eType = tag.func_74762_e("entityType")) >= 0 && eType < EntityFilterType.values().length) {
            this.entityFilter = EntityFilterType.values()[eType];
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("ox", this.rangeX);
        tag.func_74768_a("oy", this.rangeY);
        tag.func_74768_a("oz", this.rangeZ);
        tag.func_74768_a("limit", this.limitUntilRedstone);
        tag.func_74768_a("compare", this.compType.ordinal());
        tag.func_74768_a("entityType", this.entityFilter.ordinal());
        return super.func_189515_b(tag);
    }

    static enum Fields {
        GREATERTHAN,
        LIMIT,
        RANGEX,
        RANGEY,
        RANGEZ,
        ENTITYTYPE,
        RENDER;

    }
}

