/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderctrl;

import com.lothrazar.cyclic.block.enderctrl.EnderControllerItemHandler;
import com.lothrazar.cyclic.block.endershelf.EnderShelfItemHandler;
import com.lothrazar.cyclic.registry.BlockRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class EnderShelfHelper {
    public static final int MAX_ITERATIONS = 64;

    public static BlockPos findConnectedController(World world, BlockPos shelfPos) {
        return EnderShelfHelper.recursivelyFindConnectedController(world, shelfPos, new HashMap<BlockPos, Integer>(), 0);
    }

    private static BlockPos recursivelyFindConnectedController(World world, BlockPos pos, Map<BlockPos, Integer> visitedLocations, int iterations) {
        BlockState state = world.func_180495_p(pos);
        if (iterations > 64) {
            return null;
        }
        if (EnderShelfHelper.isController(state)) {
            return pos;
        }
        if (!EnderShelfHelper.isShelf(state) || visitedLocations.containsKey(pos)) {
            return null;
        }
        visitedLocations.put(pos, iterations);
        BlockPos[] possibleControllers = new BlockPos[Direction.values().length];
        BlockPos returnController = null;
        int index = 0;
        ++iterations;
        for (Direction direction : Direction.values()) {
            if (state.func_177229_b((Property)BlockStateProperties.field_208157_J) != direction) {
                possibleControllers[index] = EnderShelfHelper.recursivelyFindConnectedController(world, pos.func_177972_a(direction), visitedLocations, iterations);
            }
            if (possibleControllers[index] == null) continue;
            returnController = possibleControllers[index];
        }
        return returnController;
    }

    public static Set<BlockPos> findConnectedShelves(World world, BlockPos controllerPos) {
        return EnderShelfHelper.recursivelyFindConnectedShelves(world, controllerPos, new HashSet<BlockPos>(), new HashSet<BlockPos>(), 0);
    }

    public static Set<BlockPos> recursivelyFindConnectedShelves(World world, BlockPos pos, Set<BlockPos> visitedLocations, Set<BlockPos> shelves, int iterations) {
        BlockState state = world.func_180495_p(pos);
        if (visitedLocations.contains(pos)) {
            return shelves;
        }
        visitedLocations.add(pos);
        if (iterations > 64) {
            return shelves;
        }
        if (iterations > 0 && !EnderShelfHelper.isShelf(state)) {
            return shelves;
        }
        if (iterations > 0) {
            shelves.add(pos);
        }
        ++iterations;
        for (Direction direction : Direction.values()) {
            if (state.func_177229_b((Property)BlockStateProperties.field_208157_J) == direction) continue;
            shelves.addAll(EnderShelfHelper.recursivelyFindConnectedShelves(world, pos.func_177972_a(direction), visitedLocations, shelves, iterations));
        }
        return shelves;
    }

    public static EnderShelfItemHandler getShelfHandler(TileEntity te) {
        if (te != null && te.func_195044_w().func_177230_c() == BlockRegistry.ender_shelf && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get() instanceof EnderShelfItemHandler) {
            return (EnderShelfItemHandler)((Object)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get());
        }
        return null;
    }

    public static EnderControllerItemHandler getControllerHandler(TileEntity te) {
        if (te != null && te.func_195044_w().func_177230_c() == BlockRegistry.ender_controller && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get() instanceof EnderControllerItemHandler) {
            return (EnderControllerItemHandler)((Object)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get());
        }
        return null;
    }

    public static boolean isController(BlockState state) {
        return state.func_177230_c() == BlockRegistry.ender_controller;
    }

    public static boolean isShelf(BlockState state) {
        return state.func_177230_c() == BlockRegistry.ender_shelf;
    }
}

