/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.fishing;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.fishing.ContainerFisher;
import com.lothrazar.cyclic.registry.DataTags;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileFisher
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int RADIUS = 12;
    private static final double CHANCE = 0.1;
    ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b().func_206844_a(DataTags.RODS);
        }
    };
    LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileFisher() {
        super(TileRegistry.fisher);
        this.needsRedstone = 0;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerFisher(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        int z;
        int y;
        int x;
        BlockPos center;
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.func_77973_b().func_206844_a(DataTags.RODS) && this.isWater(center = new BlockPos(x = this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextInt(24) - 12, y = this.field_174879_c.func_177956_o(), z = this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextInt(24) - 12))) {
            try {
                this.doFishing(stack, center);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Fishing Block: Loot table failed", e);
            }
        }
    }

    private boolean isWater(BlockPos center) {
        return this.field_145850_b.func_180495_p(center).func_177230_c() == Blocks.field_150355_j;
    }

    private void doFishing(ItemStack fishingRod, BlockPos center) {
        World world = this.func_145831_w();
        Random rand = world.field_73012_v;
        if (rand.nextDouble() < 0.1 && world instanceof ServerWorld) {
            LootTableManager manager = world.func_73046_m().func_200249_aQ();
            if (manager == null) {
                return;
            }
            LootTable table = manager.func_186521_a(LootTables.field_186387_al);
            if (table == null) {
                return;
            }
            int luck = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_151370_z, (ItemStack)fishingRod) + 1;
            Vector3d fffffffffff = new Vector3d((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p());
            LootContext lootContext = new LootContext.Builder((ServerWorld)world).func_186469_a((float)luck).func_216023_a(rand).func_216015_a(LootParameters.field_237457_g_, (Object)fffffffffff).func_216015_a(LootParameters.field_216289_i, (Object)fishingRod).func_216022_a(LootParameterSets.field_216262_c);
            List lootDrops = table.func_216113_a(lootContext);
            if (lootDrops != null && lootDrops.size() > 0) {
                UtilItemStack.damageItem(fishingRod);
                UtilItemStack.drop(world, center, lootDrops);
            }
        }
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return 0;
    }

    static enum Fields {
        REDSTONE;

    }
}

