/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.harvester;

import com.google.common.collect.Sets;
import com.lothrazar.cyclic.api.IHarvesterOverride;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.harvester.ContainerHarvester;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.DataTags;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilShape;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileHarvester
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    public static final Set<IHarvesterOverride> HARVEST_OVERRIDES = Sets.newIdentityHashSet();
    public static final int MAX_SIZE = 12;
    static final int MAX_ENERGY = 640000;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private int radius = 12;
    private int shapeIndex = 0;
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 160000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);

    public TileHarvester() {
        super(TileRegistry.harvesterTile);
        this.timer = 1;
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPos targetPos = this.getShapeTarget();
        ++this.shapeIndex;
        if (targetPos != null && TileHarvester.tryHarvestSingle(this.field_145850_b, targetPos)) {
            this.energy.extractEnergy(cost, false);
        }
    }

    private BlockPos getShapeTarget() {
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return null;
        }
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        return shape.get(this.shapeIndex);
    }

    public List<BlockPos> getShape() {
        int height = 0;
        List<BlockPos> shape = UtilShape.cubeSquareBase(this.getCurrentFacingPos(this.radius + 1), this.radius, height);
        return shape;
    }

    public List<BlockPos> getShapeHollow() {
        List<BlockPos> shape = UtilShape.squareHorizontalHollow(this.getCurrentFacingPos(this.radius + 1), this.radius);
        return shape;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public static boolean tryHarvestSingle(World world, BlockPos posCurrent) {
        BlockState newState;
        boolean updated;
        CropsBlock crop;
        Object defaultSeedDrop;
        int maxAge;
        BlockState blockState = world.func_180495_p(posCurrent);
        IHarvesterOverride applicable = null;
        for (IHarvesterOverride override : HARVEST_OVERRIDES) {
            if (!override.appliesTo(blockState, world, posCurrent)) continue;
            applicable = override;
            break;
        }
        if (applicable != null) {
            return applicable.attemptHarvest(blockState, world, posCurrent, stack -> UtilItemStack.drop(world, posCurrent, blockState.func_177230_c()));
        }
        if (TileHarvester.simpleBreakDrop(blockState)) {
            UtilItemStack.drop(world, posCurrent, blockState.func_177230_c());
            world.func_175655_b(posCurrent, false);
            return true;
        }
        if (world.func_180495_p(posCurrent).func_177230_c() instanceof StemBlock) {
            return false;
        }
        IntegerProperty propInt = TileHarvester.getAgeProp(blockState);
        if (propInt == null || !(world instanceof ServerWorld)) {
            return false;
        }
        int currentAge = (Integer)blockState.func_177229_b((Property)propInt);
        int minAge = (Integer)Collections.min(propInt.func_177700_c());
        if (minAge == (maxAge = ((Integer)Collections.max(propInt.func_177700_c())).intValue()) || currentAge < maxAge) {
            return false;
        }
        Item seed = null;
        if (blockState.func_177230_c() instanceof CropsBlock && !(defaultSeedDrop = (crop = (CropsBlock)blockState.func_177230_c()).func_185473_a((IBlockReader)world, posCurrent, blockState)).func_190926_b()) {
            seed = defaultSeedDrop.func_77973_b();
        }
        List drops = Block.func_220070_a((BlockState)blockState, (ServerWorld)((ServerWorld)world), (BlockPos)posCurrent, null);
        for (ItemStack dropStack : drops) {
            if (seed != null && dropStack.func_77973_b() == seed) {
                dropStack.func_190918_g(1);
                seed = null;
            }
            UtilWorld.dropItemStackInWorld(world, posCurrent, dropStack);
        }
        if (world instanceof ServerWorld) {
            blockState.func_215706_a((ServerWorld)world, posCurrent, ItemStack.field_190927_a);
        }
        return (updated = world.func_175656_a(posCurrent, newState = (BlockState)blockState.func_206870_a((Property)propInt, (Comparable)Integer.valueOf(minAge)))) || drops.size() > 0;
    }

    private static boolean simpleBreakDrop(BlockState blockState) {
        boolean breakit = blockState.func_235714_a_(DataTags.VINES) || blockState.func_235714_a_(DataTags.CROPBLOCKS);
        return breakit;
    }

    public static IntegerProperty getAgeProp(BlockState blockState) {
        if (blockState.func_177230_c() instanceof CropsBlock) {
            CropsBlock crops = (CropsBlock)blockState.func_177230_c();
            return crops.func_185524_e();
        }
        String age = CropsBlock.field_176488_a.func_177701_a();
        ResourceLocation bid = blockState.func_177230_c().getRegistryName();
        if ("resynth".equalsIgnoreCase(bid.func_110624_b())) {
            age = "growth_stage";
        }
        for (Property p : blockState.func_235904_r_()) {
            if (p == null || p.func_177701_a() == null || !(p instanceof IntegerProperty) || !p.func_177701_a().equalsIgnoreCase(age)) continue;
            return (IntegerProperty)p;
        }
        return null;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case SIZE: {
                return this.radius;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case SIZE: {
                this.radius = Math.min(value, 12);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.radius = tag.func_74762_e("radius");
        this.shapeIndex = tag.func_74762_e("shapeIndex");
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("radius", this.radius);
        tag.func_74768_a("shapeIndex", this.shapeIndex);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        return super.func_189515_b(tag);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerHarvester(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE;

    }
}

