/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.melter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.melter.TileMelter;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeMelter<TileEntityBase>
extends CyclicRecipe {
    private NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();
    private FluidStack outFluid;
    public static final SerializeMelter SERIALMELTER = new SerializeMelter();

    public RecipeMelter(ResourceLocation id, Ingredient in, Ingredient inSecond, FluidStack out) {
        super(id);
        this.ingredients.add((Object)in);
        if (inSecond == null) {
            inSecond = Ingredient.field_193370_a;
        }
        this.ingredients.add((Object)inSecond);
        this.outFluid = out;
    }

    public boolean matches(TileEntityBase inv, World worldIn) {
        try {
            TileMelter tile = (TileMelter)inv;
            boolean matchLeft = this.matches(tile.getStackInputSlot(0), (Ingredient)this.ingredients.get(0));
            boolean matchRight = this.matches(tile.getStackInputSlot(1), (Ingredient)this.ingredients.get(1));
            return matchLeft && matchRight;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(ItemStack current, Ingredient ing) {
        if (ing == Ingredient.field_193370_a) {
            return current.func_190926_b();
        }
        if (current.func_190926_b()) {
            return ing == Ingredient.field_193370_a;
        }
        return ing.test(current);
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.func_193365_a();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    @Override
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Override
    public FluidStack getRecipeFluid() {
        return this.outFluid.copy();
    }

    public IRecipeType<?> func_222127_g() {
        return CyclicRecipeType.MELTER;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALMELTER;
    }

    public static class SerializeMelter
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeMelter<? extends TileEntityBase>> {
        SerializeMelter() {
            this.setRegistryName(new ResourceLocation("cyclic", "melter"));
        }

        public RecipeMelter<? extends TileEntityBase> read(ResourceLocation recipeId, JsonObject json) {
            RecipeMelter r = null;
            try {
                Ingredient inputFirst = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"inputFirst"));
                Ingredient inputSecond = Ingredient.field_193370_a;
                if (JSONUtils.func_151204_g((JsonObject)json, (String)"inputSecond")) {
                    inputSecond = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"inputSecond"));
                }
                JsonObject result = json.get("result").getAsJsonObject();
                int count = result.get("count").getAsInt();
                String fluidId = JSONUtils.func_151200_h((JsonObject)result, (String)"fluid");
                ResourceLocation resourceLocation = new ResourceLocation(fluidId);
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
                r = new RecipeMelter(recipeId, inputFirst, inputSecond, new FluidStack(fluid, count));
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe" + recipeId, e);
            }
            ModCyclic.LOGGER.info("Recipe loaded " + r.func_199560_c().toString());
            return r;
        }

        public RecipeMelter read(ResourceLocation recipeId, PacketBuffer buffer) {
            RecipeMelter r = new RecipeMelter(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer), Ingredient.func_199566_b((PacketBuffer)buffer), FluidStack.readFromPacket((PacketBuffer)buffer));
            return r;
        }

        public void write(PacketBuffer buffer, RecipeMelter recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            Ingredient one = (Ingredient)recipe.ingredients.get(1);
            zero.func_199564_a(buffer);
            one.func_199564_a(buffer);
            recipe.outFluid.writeToPacket(buffer);
        }
    }
}

