/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.peatfarm;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.PeatFuelBlock;
import com.lothrazar.cyclic.block.peatfarm.ContainerPeatFarm;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TilePeatFarm
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    public static ForgeConfigSpec.IntValue POWERCONF;
    public static final int CAPACITY = 64000;
    static final int MAX = 64000;
    public static final int TIMER_FULL = 10;
    private static final int PER_TICK = 1;
    FluidTankBase tank;
    private final LazyOptional<FluidTankBase> tankWrapper = LazyOptional.of(() -> this.tank);
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    ItemStackHandler inventory = new ItemStackHandler(6){

        public boolean isItemValid(int slot, ItemStack stack) {
            return Block.func_149634_a((Item)stack.func_77973_b()) == BlockRegistry.peat_unbaked;
        }
    };
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int blockPointer = 0;
    Block baked = null;
    Block unbaked = null;
    List<BlockPos> outer = null;

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerPeatFarm(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    private void init() {
        if (this.baked == null) {
            this.baked = BlockRegistry.peat_baked;
        }
        if (this.unbaked == null) {
            this.unbaked = BlockRegistry.peat_unbaked;
        }
        if (this.outer == null) {
            this.outer = this.getShape();
            List<BlockPos> waterShape = UtilShape.squareHorizontalHollow(this.field_174879_c, 6);
            this.outer.addAll(waterShape);
        }
    }

    public void func_73660_a() {
        this.syncEnergy();
        this.init();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            this.blockPointer = 0;
            return;
        }
        this.setLitProperty(true);
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            if (this.blockPointer < this.outer.size()) {
                boolean placeWater;
                BlockPos target = this.outer.get(this.blockPointer);
                boolean bl = placeWater = (target.func_177958_n() - this.field_174879_c.func_177958_n()) % 3 == 0 && (target.func_177952_p() - this.field_174879_c.func_177952_p()) % 3 == 0;
                if (placeWater) {
                    if (this.tryPlaceWater(target)) {
                        this.energy.extractEnergy(cost, false);
                    }
                } else if (this.tryPlacePeat(target)) {
                    this.energy.extractEnergy(cost, false);
                }
                ++this.blockPointer;
                continue;
            }
            this.blockPointer = 0;
        }
        this.timer = 10;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    public TilePeatFarm() {
        super(TileRegistry.peat_farm);
        this.tank = new FluidTankBase(this, 64000, this.isFluidValid());
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) == this.unbaked;
    }

    List<BlockPos> getShape() {
        List<BlockPos> outer = UtilShape.squareHorizontalHollow(this.field_174879_c, 7);
        outer.addAll(UtilShape.squareHorizontalHollow(this.field_174879_c, 5));
        return outer;
    }

    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    public float getCapacity() {
        return 64000.0f;
    }

    private boolean tryPlacePeat(BlockPos target) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            BlockState state = Block.func_149634_a((Item)itemStack.func_77973_b()).func_176223_P();
            if (itemStack.func_190916_E() == 0) continue;
            if (this.field_145850_b.func_180495_p(target).func_177230_c() instanceof PeatFuelBlock) {
                this.field_145850_b.func_175655_b(target, true);
            }
            if (!this.field_145850_b.func_175623_d(target) && this.field_145850_b.func_204610_c(target).func_206886_c() != Fluids.field_204546_a && this.field_145850_b.func_204610_c(target).func_206886_c() != Fluids.field_207212_b || !this.field_145850_b.func_175656_a(target, state)) continue;
            itemStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    private boolean tryPlaceWater(BlockPos target) {
        if (this.field_145850_b.func_180495_p(target).func_227032_a_((Fluid)Fluids.field_204546_a) && this.field_145850_b.func_180495_p(target).func_177230_c() != Blocks.field_150355_j && this.tank.getFluidAmount() >= 1000 && this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE) != null) {
            this.field_145850_b.func_175656_a(target, Blocks.field_150355_j.func_176223_P());
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankWrapper.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    static enum Fields {
        REDSTONE,
        RENDER;

    }
}

