/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.placerfluid;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.placerfluid.ContainerPlacerFluid;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TilePlacerFluid
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    public static final int CAPACITY = 8000;
    FluidTankBase tank = new FluidTankBase(this, 8000, this.isFluidValid());

    public TilePlacerFluid() {
        super(TileRegistry.placer_fluid);
        this.needsRedstone = 1;
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        FluidStack test = this.tank.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (test.getAmount() == 1000 && test.getFluid().func_207188_f() != null && test.getFluid().func_207188_f().func_206883_i() != null) {
            Direction dir = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
            BlockPos offset = this.field_174879_c.func_177972_a(dir);
            BlockState state = test.getFluid().func_207188_f().func_206883_i();
            if (this.field_145850_b.func_175623_d(offset) && this.field_145850_b.func_175656_a(offset, state)) {
                this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerPlacerFluid(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        return super.func_189515_b(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    static enum Fields {
        REDSTONE,
        RENDER;

    }
}

